
using System;
using System.Data;
using System.Web.UI.WebControls;
using System.Web.SessionState;
using AVC.Passport;
using AVC.Passport.DataEntity;

	/// <summary>
	/// Rights编辑
	/// </summary>
public partial class RightsEdit : LoginPageBase
	{

		private void Page_Load(object sender, System.EventArgs e)
		{
			if(!IsPostBack)
			{
				string strAction = Request.QueryString["action"];
				// 自动编号
				
				txtRightID.ReadOnly = true;
				txtRightID.Text = "自动增长";
				
				ViewState["Action"] = strAction;
				if(strAction == "edit")
				{
					System.Int32 RightID = System.Int32.Parse(Request.QueryString["RightID"]);
                    Rights objRights = RightsBiz.GetRights(RightID);					
					txtRightID.Text = objRights.RightID.ToString();
					txtRightName.Text = objRights.RightName;
					txtRightTypeID.Text = objRights.RightTypeID.ToString();
					txtSubSystemID.Text = objRights.SubSystemID;
					txtRightDisplayName.Text = objRights.RightDisplayName;
					txtRightMemo.Text = objRights.RightMemo;
					txtRightID.ReadOnly = true;
					
				}
			}
		}

		public void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				if((string)ViewState["Action"] == "add")
				{
					Rights objRights = new Rights();
					
					objRights.RightName = txtRightName.Text;
					objRights.RightTypeID = System.Int32.Parse(txtRightTypeID.Text);
					objRights.SubSystemID = txtSubSystemID.Text;
					objRights.RightDisplayName = txtRightDisplayName.Text;
					objRights.RightMemo = txtRightMemo.Text;
                    RightsBiz.AddRights(objRights);
					ViewState["Action"] = "edit";
					
					txtRightID.ReadOnly = true;
					
					txtRightID.ReadOnly = true;
					txtRightID.Text = objRights.RightID.ToString();
					
				}
				else if((string)ViewState["Action"] == "edit")
				{
					Rights objRights = RightsBiz.GetRights(System.Int32.Parse(txtRightID.Text));
					
					objRights.RightID = System.Int32.Parse(txtRightID.Text);
					
					objRights.RightName = txtRightName.Text;
					
					objRights.RightTypeID = System.Int32.Parse(txtRightTypeID.Text);
					
					objRights.SubSystemID = txtSubSystemID.Text;
					
					objRights.RightDisplayName = txtRightDisplayName.Text;
					
					objRights.RightMemo = txtRightMemo.Text;

					RightsBiz.UpdateRights(objRights);
				}
				lblMessage.Text = "保存成功！";
			}
			catch(Exception ex)
			{
				lblMessage.Text = ex.Message;
			}
		}
	}
