using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using AVC.Passport;
using AVC.Passport.DataEntity;
public partial class UserGroup : LoginPageBase
{
    protected void Page_Load(object sender, EventArgs e)
    {
        btnAdd.Attributes.Add("onclick", "return BeforeSubmit('" + btnAdd.ClientID + "');");
        btnRemove.Attributes.Add("onclick", "return BeforeSubmit('" + btnRemove.ClientID + "');");

        if (!IsPostBack)
        {
            //判断权限
            if (!CheckRight("UserAdmin"))
            {
                NoRightAlert();
            }

            string strSubSystemID =   "SYS002";
            ViewState["SubSystemID"] = strSubSystemID;

            string strUserID = Request.QueryString["userid"];
            int intUserID;
            int.TryParse(strUserID, out intUserID);

            ViewState["UserID"] = intUserID;
            ViewState["ParentGroup"] = 0;
            BindGroups();
            BindUserGroup();
        }
    }
    private DataTable GetGroups()
    {
        DataTable dtGroups = GroupBiz.GetGroupBySubSystemIDAndParentID((string)ViewState["SubSystemID"], (int)ViewState["ParentGroup"]);
        DataTable dtUserGroups = UserMstBiz.GetUserGroup((string)ViewState["SubSystemID"], (int)ViewState["UserID"]);

        for (int i = dtGroups.Rows.Count - 1; i >= 0; i--)
        {
            if (dtUserGroups.Select("GroupID='" + ((int)dtGroups.Rows[i]["GroupID"]).ToString() + "'").Length != 0)
                dtGroups.Rows.RemoveAt(i);
        }
        btnBackParent.Visible = (int)ViewState["ParentGroup"] != 0;
        return dtGroups;
    }
    private void BindData(int CurrentPage, string Sort)
    {
        int TotalPage = 0;//总页数
        int TotalRecord = 0;//总记录数
        int PageSize = 10;
        dgGroups.DataSource = GroupBiz.GetGroupSelectAllPaged(CurrentPage - 1, out TotalPage, out TotalRecord, PageSize, Sort);
        dgGroups.DataBind();

        ViewState["Page"] = CurrentPage;
        ViewState["Sort"] = Sort;
        if (CurrentPage <= 1)
        {
            //如果当前页已经是第1页
            lbtnPrevious.Enabled = false;

            lbtnNext.Enabled = true;

            ViewState["Page"] = 1;
        }
        else if (CurrentPage >= TotalPage)
        {//如果当前项已经是最末页

            lbtnNext.Enabled = false;

            lbtnPrevious.Enabled = true;
            ViewState["Page"] = TotalPage;
        }
        else
        {
            lbtnNext.Enabled = true;
            lbtnPrevious.Enabled = true;
        }

    }

    protected void lbtnFirst_Click(object sender, EventArgs e)
    {
        string Sort = (string)ViewState["Sort"];
        if (Sort != null)
        {
            BindData(1, Sort);
        }
        else
        {
            BindData(1, "UserID,RightID");
        }
    }

    protected void lbtnNext_Click(object sender, EventArgs e)
    {
        string Sort = (string)ViewState["Sort"];
        int Page = int.Parse(ViewState["Page"].ToString());
        Page++;
        if (Sort != null)
        {
            BindData(Page, Sort);
        }
        else
        {
            BindData(Page, "UserID,RightID");
        }
    }
    protected void lbtnPrevious_Click(object sender, EventArgs e)
    {
        string Sort = (string)ViewState["Sort"];
        int Page = int.Parse(ViewState["Page"].ToString());
        Page--;
        if (Sort != null)
        {
            BindData(Page, Sort);
        }
        else
        {
            BindData(1, "UserID,RightID");
        }
    }


    protected void btnBackParent_Click(object sender, EventArgs e)
    {

    }
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        CheckBox chkSelect = null;
        for (int i = 0; i < dgGroups.Rows.Count; i++)
        {
            chkSelect = (CheckBox)dgGroups.Rows[i].FindControl("chkSelect");
            if (chkSelect.Checked)
            {
                UserMstBiz.AddUserGroup((int)ViewState["UserID"], int.Parse(dgGroups.Rows[i].Cells[1].Text), UserID);
            }
        }
        BindGroups();
        BindUserGroup();
    }


    private void BindGroups()
    {
        DataView dvGroups = new DataView(GetGroups());
        dvGroups.Sort = (string)ViewState["GroupsSort"];
        dgGroups.DataSource = dvGroups;
        dgGroups.DataBind();
    }

    private void BindUserGroup()
    {
        DataView dvUserGroups = new DataView(GetUserGroup());
        dvUserGroups.Sort = (string)ViewState["UserGroupsSort"];
        dgUserGroup.DataSource = dvUserGroups;
        dgUserGroup.DataBind();
    }

    private DataTable GetUserGroup()
    {
        return UserMstBiz.GetUserGroup("SYS002", (int)ViewState["UserID"]);
    }

    protected void btnRemove_Click(object sender, EventArgs e)
    {
        CheckBox chkDeselect = null;
        for (int i = 0; i < dgUserGroup.Rows.Count; i++)
        {
            chkDeselect = (CheckBox)dgUserGroup.Rows[i].FindControl("chkDeselect");
            if (chkDeselect.Checked)
            {
                UserMstBiz.RemoveUserGroup((int)ViewState["UserID"], int.Parse(dgUserGroup.Rows[i].Cells[1].Text));
            }
        }
        BindGroups();
        BindUserGroup();
    }
    protected void dgUserGroup_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Delete")
        {
            if (!string.IsNullOrEmpty((string)e.CommandArgument))
            {

                User_RightsBiz.DeleteUser_Rights(int.Parse(e.CommandArgument.ToString()), 0);
                string Sort = (string)ViewState["Sort"];
                int Page = int.Parse(ViewState["Page"].ToString());
                Alert("刪除成功");
                if (Sort != null)
                {
                    BindData(Page, Sort);
                }
                else
                {
                    BindData(1, "UserID,RightID");
                }
            }
        }
    }
    protected void dgUserGroup_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {

    }
    protected void dgUserGroup_Sorting(object sender, GridViewSortEventArgs e)
    {
        if (e.SortExpression == (string)ViewState["Sort"])
            ViewState["Sort"] = e.SortExpression + " DESC";
        else
            ViewState["Sort"] = e.SortExpression;

        BindData(int.Parse(ViewState["Page"].ToString()), (string)ViewState["Sort"]);
    }
}
