﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //网页描述
        Showdescription();
        this.Title = ConfigurationManager.AppSettings["WebTitle"].ToString();
        if (!Page.IsPostBack)
        {
            Shownote();
            Bindproduct();
            Bindjianjie();
            Bindnews(Newsgridview, "企业新闻");
            Bindnews(Zixungridview, "业内资讯");
            Bindnews(Jishugridview, "技术文档");
        }
        Bindbtn();
    }
    //绑定产品控件
    private void Bindproduct()
    {
        DataSet ds = Getproduct();
        ProductDataList.DataSource = ds.Tables["aa"].DefaultView;
        ProductDataList.DataBind();
        ds.Clear();
    }
    //打开产品数据库
    public DataSet Getproduct()
    {
        INews shownews = new Mynews();
        DataSet ds = shownews.DsGetinfo("SELECT TOP 10 ProductID,Title,Imgurl FROM Product WHERE Imgurl!='' ORDER BY Showorder DESC");
       
        return ds;
    }
    //绑定企业新闻控件
    private void Bindnews(GridView GV,string sLeibie)
    {
        INews shownews = new Mynews();
        DataSet ds = shownews.Getnews(sLeibie,8);
        GV.DataSource = ds.Tables["aa"].DefaultView;
        GV.DataBind();
    }
    //绑定企业简介控件
    private void Bindjianjie()
    {
        INews shownews = new Mynews();
        SqlDataReader dr = shownews.Getcorp();
        string jiajie = "";
        if (dr.Read())
        {
            jiajie = dr["Content"].ToString();
            if (jiajie.Length > 340)
            {
                jiajie = jiajie.Substring(0, 340) + "...";
            }
        }
        lblJianjie.Text = jiajie;
        dr.Close();
    }
   
    //产品标题字数限制
    protected string Mytitle(string sTitle)
    {
        
        if (sTitle.Length > 8)
        {
            sTitle = sTitle.Substring(0, 8);
        }
        return sTitle;

    }
    //网描述
    public string Showdescription()
    {
        HtmlMeta cs1 = new HtmlMeta();
        cs1.Name = "keywords";
        cs1.Content = ConfigurationManager.AppSettings["Keywords"];
        HtmlMeta cs2 = new HtmlMeta();
        cs2.Name = "description";
        cs2.Content = ConfigurationManager.AppSettings["Description"];
        Page.Header.Controls.Add(cs1);
        Page.Header.Controls.Add(cs2);
        return "";
    }
    //鼠标悬停按钮
    private void Bindbtn()
    {
        jianjie_btn.Attributes.Add("OnMouseOver", "document.getElementById('Jishugridview').style.display='none';document.getElementById('Zixungridview').style.display='none';document.getElementById('Newsgridview').style.display='none';document.getElementById('lblJianjie').style.display='block';this.src='pics/newtop1_01.gif';");
        jianjie_btn.Attributes.Add("OnMouseOut", "this.src='pics/newtop2_01.gif'");

        news_btn.Attributes.Add("OnMouseOver", "document.getElementById('lblJianjie').style.display='none';document.getElementById('Jishugridview').style.display='none';document.getElementById('Zixungridview').style.display='none';document.getElementById('Newsgridview').style.display='block';this.src='pics/newtop1_02.gif'");
        news_btn.Attributes.Add("OnMouseOut", "this.src='pics/newtop2_02.gif'");

        zixun_btn.Attributes.Add("OnMouseOver", "document.getElementById('lblJianjie').style.display='none';document.getElementById('Jishugridview').style.display='none';document.getElementById('Newsgridview').style.display='none';document.getElementById('Zixungridview').style.display='block';this.src='pics/newtop1_03.gif'");
        zixun_btn.Attributes.Add("OnMouseOut", "this.src='pics/newtop2_03.gif'");

        jishu_btn.Attributes.Add("OnMouseOver", "document.getElementById('lblJianjie').style.display='none';document.getElementById('Zixungridview').style.display='none';document.getElementById('Newsgridview').style.display='none';document.getElementById('Jishugridview').style.display='block';this.src='pics/newtop1_04.gif'");
        jishu_btn.Attributes.Add("OnMouseOut", "this.src='pics/newtop2_04.gif'");
    }
    private void Shownote()
    {
        SqlDataReader dr = Getnote();
        if (dr.Read())
        {
            string mystr = dr["Content"].ToString();
            mystr = mystr.Replace(" ", "&nbsp;&nbsp;");
            mystr = mystr.Replace("\r\n", "</br>");
            lblNote.Text = "<marquee behavior='loop' scrollDelay='100' scrollAmount='1'direction='down' onmouseout=this.start() onmouseover=this.stop() style='font-size: 9pt; line-height:12pt;color:black'>" + mystr + "</marquee>";

        }
    }
    public SqlDataReader Getnote()
    {
        SqlConnection myConnection = new SqlConnection(ConfigurationManager.ConnectionStrings["MYCONNECTIONSTRING"].ConnectionString);
        string cmdText = "SELECT * FROM Webnote ORDER BY Showorder DESC";
        SqlCommand myCommand = new SqlCommand(cmdText, myConnection);
        SqlDataReader dr = null;
        try
        {
            myConnection.Open();
            dr = myCommand.ExecuteReader(CommandBehavior.CloseConnection);
        }
        catch (SqlException ex)
        {
            throw new Exception(ex.Message, ex);
        }
        return dr;
    }

    
}
