﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class _Default : System.Web.UI.Page 
{
    static string sLeibie = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            if (Request.Params["ShowID"] != null)
            {
                lblCurrent.Text = "1";
                sLeibie = Request.Params["ShowID"].ToString();
                Bindnews(sLeibie, Newsgridview);
                lblLeibie.Text = sLeibie;
                this.Title = ConfigurationManager.AppSettings["WebTitle"].ToString() + "--" + sLeibie;
            }
            
        }
        
    }
    //绑定新闻控件
    private void Bindnews(string sNews,GridView myGridView)
    {
        INews Shownews = new Mynews();
        DataSet ds = Shownews.Getnews(sNews,16);

        PagedDataSource pds = new PagedDataSource();
        pds.DataSource = ds.Tables[0].DefaultView;
        pds.AllowPaging = true;
        pds.PageSize = 16;
        int CurrentPage = Convert.ToInt32(lblCurrent.Text);
        pds.CurrentPageIndex = CurrentPage - 1;
        lblTotal.Text = pds.PageCount.ToString();
        if (CurrentPage == 1)
        {
            FirstPage.Enabled = false;
            PrePage.Enabled = false;
            NextPage.Enabled = true;
            LastPage.Enabled = true;
        }
        if (CurrentPage == pds.PageCount)
        {
            NextPage.Enabled = false;
            LastPage.Enabled = false;
            FirstPage.Enabled = true;
            PrePage.Enabled = true;
        }
        if (CurrentPage > 1 && CurrentPage < pds.PageCount)
        {
            FirstPage.Enabled = true;
            PrePage.Enabled = true;
            NextPage.Enabled = true;
            LastPage.Enabled = true;
        }
        if (lblTotal.Text.ToString() == "1")
        {
            FirstPage.Enabled = false;
            PrePage.Enabled = false;
            NextPage.Enabled = false;
            LastPage.Enabled = false;
        }
        BindDrpage(pds.PageCount);    

        myGridView.DataSource = pds;
        myGridView.DataBind();
    }
    //绑定下拉页
    private void BindDrpage(int nCount)
    {
        drpPage.Items.Clear();
        for (int i = 1; i < nCount + 1; i++)
        {
            drpPage.Items.Add(new ListItem(i.ToString(), i.ToString()));
        }
        drpPage.SelectedIndex = Convert.ToInt32(lblCurrent.Text.ToString()) - 1;
    }
    protected void drpPage_SelectedIndexChanged(object sender, EventArgs e)
    {
        lblCurrent.Text = drpPage.SelectedValue.ToString();
        Bindnews(sLeibie, Newsgridview);
    }
    protected void FirstPage_Click(object sender, EventArgs e)
    {

        lblCurrent.Text = "1";
        Bindnews(sLeibie, Newsgridview);
    }
    protected void PrePage_Click(object sender, EventArgs e)
    {
        lblCurrent.Text = Convert.ToString(Convert.ToUInt32(lblCurrent.Text) - 1);
        Bindnews(sLeibie, Newsgridview);
    }
    protected void NextPage_Click(object sender, EventArgs e)
    {
        lblCurrent.Text = Convert.ToString(Convert.ToInt32(lblCurrent.Text) + 1);
        Bindnews(sLeibie, Newsgridview);
    }
    protected void LastPage_Click(object sender, EventArgs e)
    {
        lblCurrent.Text = lblTotal.Text;
        Bindnews(sLeibie, Newsgridview);
    }
}
