﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class manage_Editproduct : System.Web.UI.Page
{
    static int nResult = -1;
    protected void Page_Load(object sender, EventArgs e)
    {
        Loginjudge();
        if (!Page.IsPostBack)
        {
            if (Request.Params["ShowID"] != null)
            {
                if (Int32.TryParse(Request.Params["ShowID"].ToString(), out nResult) == false) { return; }
                ShowproductByID(nResult);
            }
        }
    }
    //按产品ID显示产品信息
    private void ShowproductByID(int nProductID)
    {
        INews Shownews = new Mynews();
        SqlDataReader dr = Shownews.Getproduct(nProductID);
        if (dr.Read())
        {
            txtName.Text = dr["Title"].ToString();
            FreeTextBox1.Text = dr["Content"].ToString();
            txtXuhao.Text = dr["Showorder"].ToString();
            if (dr["Imgurl"].ToString().Length < 1)
            {
                lblImage.Text = "<img src='../pics/wutu.gif'/ alt='产品图示'>";
                lblImgurl.Text = "";
            }
            else
            {
                lblImage.Text = "<img src='../Uploadpics/" + dr["Imgurl"].ToString() + "'/ alt='产品图示'>";
                lblImgurl.Text = dr["Imgurl"].ToString();
            }
        }
        dr.Close();
    }
    //更新产品数据库
    private void Updateproduct(int nProductID, string sTitle, string sContent, string sImgurl, int nShoworder)
    {
        SqlConnection myConnection = new SqlConnection(ConfigurationManager.ConnectionStrings["MYCONNECTIONSTRING"].ConnectionString);
        string cmdText = "UPDATE Product SET " +
            "Title='" + sTitle + "'," +
            "Content='" + sContent + "'," +
            "Imgurl='" + sImgurl + "'," +
            "Showorder=" + nShoworder + " WHERE ProductID=" + nProductID;
        SqlCommand myCommand = new SqlCommand(cmdText, myConnection);
        try
        {
            myConnection.Open();
            myCommand.ExecuteNonQuery();
        }
        catch (SqlException ex)
        {
            throw new Exception(ex.Message, ex);
        }
        finally
        {
            myConnection.Close();
        }
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        try
        {
            if (imageUpload.PostedFile.FileName == "")
            {
                Response.Write("<Script>alert('请先选择上传的图片')</Script>");
                return;
            }
            else
            {
                string year = System.DateTime.Now.Year.ToString();
                string month = System.DateTime.Now.Month.ToString();
                string day = System.DateTime.Now.Day.ToString();
                string hour = System.DateTime.Now.Hour.ToString();
                string minute = System.DateTime.Now.Minute.ToString();
                string second = System.DateTime.Now.Second.ToString();
                string xfilename = "X" + year + month + day + hour + minute + second;
                string dfilename = "D" + year + month + day + hour + minute + second;

                string filePath = imageUpload.PostedFile.FileName;
                string fileEx = filePath.Substring(filePath.LastIndexOf(".") + 1);
                string serverpath1 = Server.MapPath(@"~\Uploadpics\") + xfilename + "." + fileEx;
                string serverpath2 = Server.MapPath(@"~\Uploadpics\productpics\") + dfilename + "." + fileEx;


                //判断图片格式
                if (fileEx == "jpg" || fileEx == "bmp" || fileEx == "gif" || fileEx == "jpeg")
                {

                    System.Drawing.Image image, newimage;
                    //保存大图
                    imageUpload.SaveAs(serverpath2);
                    //生成略图
                    image = System.Drawing.Image.FromFile(serverpath2);
                    System.Drawing.Image.GetThumbnailImageAbort callb = null;
                    newimage = image.GetThumbnailImage(120, 85, callb, new System.IntPtr());
                    //把略图保存到指定的虚拟路径
                    newimage.Save(serverpath1);
                    //释放image对象占用资源
                    image.Dispose();
                    newimage.Dispose();
                    lblImage.Text = "<img src='../Uploadpics/" + xfilename + "." + fileEx + "' width='120' height='85'/>";
                    lblImgurl.Text = xfilename + "." + fileEx;

                }
                else
                {
                    Response.Write("<Script>alert('图片格式不正确')</Script>");
                }
            }
        }
        catch
        {
            Response.Write("<Script>alert('上传失败')</Script>");
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        string title = txtName.Text.ToString();
        string content = FreeTextBox1.Text.ToString();
        int showorder = 0;
        string imgurl = lblImgurl.Text.ToString();
        if (title.Length < 1 || content.Length < 1)
        {
            Response.Write("<Script>alert('产品名称和内容不能为空！')</Script>");
            return;
        }
        if (Int32.TryParse(txtXuhao.Text.ToString(), out showorder) == false)
        {
            Response.Write("<Script>alert('序号必须为0-9的数字！')</Script>");
            return;
        }
        if (showorder < 0 || showorder > 9)
        {
            Response.Write("<Script>alert('序号必须为0-9的数字！')</Script>");
            return;
        }
        Updateproduct(nResult, title, content, imgurl, showorder);
        lblError.Text = "修改成功！请返回首页查看！";
    }
    private void Loginjudge()
    {
        if (Session["Login"] == null)
        {
            Response.Redirect("Error.aspx");
        }
        else
        {
            if (Session["Login"] != "pass")
            {
                Response.Redirect("Error.aspx");
            }

        }
    }
}
