﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_DeliveryConfig, App_Web_fef3q6en" title="配送方式列表" validaterequest="false" %>

<%@ Register Assembly="FredCK.FCKeditorV2" Namespace="FredCK.FCKeditorV2" TagPrefix="FCKeditorV2" %>
<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="DeliveryListUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:GridView ID="DeliveryList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="DeliveryList_PageIndexChanging" DataKeyNames="DeliveryId"
                    PageSize="11" OnRowDeleting="DeliveryList_RowDeleting" CellPadding="0" CssClass="gv"
                    Width="100%" EmptyDataText="暂无任何配送方式" OnRowCommand="DeliveryList_RowCommand">
                    <Columns>
                        <asp:BoundField DataField="DeliveryId" HeaderText="ID">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:BoundField DataField="DeliveryName" HeaderText="配送名称" ReadOnly="True" />
                        <asp:BoundField DataField="DeliveryMoney" HeaderText="配送价格" ReadOnly="True" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <EditItemTemplate>
                                &nbsp;
                            </EditItemTemplate>
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" CausesValidation="False" CommandName="editDelivery"
                                    CommandArgument='<%# Eval("DeliveryId").ToString().Trim() %>' Text="编辑" />
                                &nbsp;<asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="添加配送方式">
                            <ItemStyle CssClass="gvBtAField" />
                            <ItemTemplate>
                                <asp:Button ID="AddBt" runat="server" CommandName="addDelivery" CommandArgument='<%# Eval("DeliveryId").ToString().Trim() %>'
                                    Text="添加配送." CssClass="addBt" CausesValidation="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="DeliverySaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            <asp:Literal ID="SaveType" runat="server" Text="添加"></asp:Literal>配送方式<asp:HiddenField
                                ID="EditId" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF" class="mainContentLeftTd">
                            配送方式名称:
                        </td>
                        <td bgcolor="#FFFFFF" class="mainContentRightTd">
                            <asp:TextBox ID="DeliveryName" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="DeliveryName"
                                Display="Dynamic" ErrorMessage="配送方式名称必须填写"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            配送价格:
                        </td>
                        <td bgcolor="#FFFFFF">
                            <asp:TextBox ID="DeliveryMoney" runat="server"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="DeliveryMoney"
                                Display="Dynamic" ErrorMessage="配送价格必须填写"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="DeliveryMoney"
                                Display="Dynamic" ErrorMessage="配送价格必须为数字" ValidationExpression="[0-9.]{0,30}"></asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            配送方式介绍:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="left" bgcolor="#ffffff">
                            <div class="mainNoLeftTd">
                                <FCKeditorV2:FCKeditor ID="DeliveryContent" runat="server" Height="400px" Width="100%">
                                </FCKeditorV2:FCKeditor>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加配送" CssClass="inputBt" OnClick="Save_Click" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
