﻿<%@ page language="C#" masterpagefile="~/Manage/Main.master" autoeventwireup="true" inherits="manage_Manager, App_Web_fef3q6en" title="管理员管理" %>

<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="ManagerListUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:GridView ID="ManagerList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="ManagerList_PageIndexChanging" DataKeyNames="ManagerId"
                    OnRowCancelingEdit="ManagerList_RowCancelingEdit" OnRowEditing="ManagerList_RowEditing"
                    OnRowUpdating="ManagerList_RowUpdating" PageSize="11" OnRowDeleting="ManagerList_RowDeleting"
                    CellPadding="0" CssClass="gv" Width="100%" OnRowDataBound="ManagerList_RowDataBound">
                    <Columns>
                        <asp:BoundField DataField="ManagerId" FooterText="Id" HeaderText="Id" ReadOnly="True" />
                        <asp:BoundField DataField="ManagerName" HeaderText="用户名" SortExpression="ManagerName"
                            ReadOnly="True" />
                        <asp:TemplateField HeaderText="密码" SortExpression="Password">
                            <EditItemTemplate>
                                <asp:TextBox ID="ChangPassword" runat="server"></asp:TextBox>
                                <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="ChangPassword"
                                    Display="Dynamic" ErrorMessage="密码至少六位" ValidationExpression="\w{6,32}"></asp:RegularExpressionValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                <asp:Label ID="Label1" runat="server" Text='<%# Bind("Password", "******") %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="PenName" HeaderText="笔名" SortExpression="PenName" />
                        <asp:TemplateField HeaderText="所属管理员组" SortExpression="MemberId">
                            <EditItemTemplate>
                                <asp:CheckBoxList ID="ManagerRoleIdList" CssClass="checkBox" runat="server">
                                </asp:CheckBoxList>
                                <asp:HiddenField ID="RoleIdHiddenField" Value='<%# Bind("RoleId") %>' runat="server" />
                            </EditItemTemplate>
                            <ItemTemplate>
                                <asp:CheckBoxList ID="ManagerRoleIdList" CssClass="checkBox" runat="server" Enabled="False">
                                </asp:CheckBoxList>
                                <asp:HiddenField ID="RoleIdHiddenField" Value='<%# Bind("RoleId") %>' runat="server" />
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        <asp:BoundField DataField="LoginUrl" HeaderText="登录后地址" SortExpression="LoginUrl" />
                        <asp:BoundField DataField="AddTime" HeaderText="添加时间" ReadOnly="True" />
                        <asp:BoundField DataField="UpTime" HeaderText="更新时间" ReadOnly="True" />
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <EditItemTemplate>
                                <asp:Button ID="UpdateBt" runat="server" CausesValidation="True" CommandName="Update"
                                    Text="更新" />
                                <asp:Button ID="CancelBt" runat="server" CausesValidation="False" CommandName="Cancel"
                                    Text="取消" />
                            </EditItemTemplate>
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" Text="编辑" CausesValidation="false" CommandName="Edit" />
                                <asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="ManagerSaveUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="2" bgcolor="#FFFFFF" class="mainTitle">
                            添加管理员&nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF" class="mainLeftTd">
                            登陆帐号:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="ManagerName" runat="server" ValidationGroup="SaveManager"></asp:TextBox>
                            <asp:CustomValidator ID="ManagerNameValidator" runat="server" ControlToValidate="ManagerName"
                                Display="Dynamic" ErrorMessage="已经存在此帐号" OnServerValidate="ManagerNameValidator_ServerValidate"
                                ValidationGroup="SaveManager"></asp:CustomValidator><asp:RequiredFieldValidator ID="RequiredFieldValidator1"
                                    runat="server" ControlToValidate="ManagerName" Display="Dynamic" ErrorMessage="帐号不能为空"
                                    ValidationGroup="SaveManager"></asp:RequiredFieldValidator><asp:RegularExpressionValidator
                                        ID="RegularExpressionValidator2" runat="server" ControlToValidate="ManagerName"
                                        Display="Dynamic" ErrorMessage="帐号应有字母或数字组成(最多12位)" ValidationExpression="[a-zA-Z0-9]{0,12}"
                                        ValidationGroup="SaveManager"></asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            密码:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="Password" runat="server" ValidationGroup="SaveManager"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="Password"
                                Display="Dynamic" ErrorMessage="密码不能为空！" ValidationGroup="SaveManager"></asp:RequiredFieldValidator><asp:RegularExpressionValidator
                                    ID="RegularExpressionValidator1" runat="server" ControlToValidate="Password"
                                    Display="Dynamic" ErrorMessage="密码长度至少六位" ValidationExpression="\w{6,32}" ValidationGroup="SaveManager"></asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            用户笔名:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="PenName" runat="server" ValidationGroup="SaveManager"></asp:TextBox><span
                                class="explain">&nbsp; 用于网站信息编辑等</span>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#ffffff">
                            所属于管理员组:
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:CheckBoxList ID="ManagerRoleCheckBoxList" CssClass="checkBox" runat="server">
                            </asp:CheckBoxList>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#ffffff">
                            登录后地址:
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:TextBox ID="LoginUrl" runat="server" ValidationGroup="SaveManager">Desktop.aspx</asp:TextBox><span
                                class="explain">&nbsp; 用户登录后跳转到的默认页面</span>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:Button ID="Save" runat="server" Text="添加用户" CssClass="inputBt" OnClick="Save_Click"
                                ValidationGroup="SaveManager" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
