﻿<%@ page language="C#" masterpagefile="~/manage/Main.master" autoeventwireup="true" inherits="manage_ProductClass, App_Web_fef3q6en" title="分类管理" %>

<asp:Content ID="Content2" ContentPlaceHolderID="MidContent" runat="Server">
    <div id="main">
        <asp:UpdatePanel ID="MsgUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Label ID="Msg" runat="server" Text="" CssClass="msg" Visible="False" EnableViewState="False"></asp:Label>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="ProductClassListUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <asp:Panel ID="MpePanel" runat="server" CssClass="" Style='display: none'>
                    <asp:Panel ID="TitlePanel" CssClass="MTop" runat="server">
                        <div class="MTopLeft">
                        </div>
                        <div class="MTopMid">
                            <a class="MTopClose" title="关闭" href="javascript:hideModalPopupViaClient('ProductClassList');">
                            </a><span class="MTitle">系统提示</span></div>
                        <div class="MTopRight">
                        </div>
                    </asp:Panel>
                    <div class="MMid">
                        <div class="MMidBox">
                            <table border="0" cellpadding="0" cellspacing="0">
                                <tbody>
                                    <tr>
                                        <th class="MIcon">
                                            <div class="MIconInfo">
                                            </div>
                                        </th>
                                        <td class="MContext">
                                            将同时删除此分类、所有子分类、及其分类内所有内容。<br />
                                            确定删除吗?
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="MBott">
                        <div class="MBottLeft">
                        </div>
                        <div class="MBottMid">
                            <div class="MBtBox">
                                <asp:Button ID="OkBt" runat="server" CssClass="MBt MOk" Text="确 定" />
                                <asp:Button ID="CancelBt" runat="server" CssClass="MBt MCancel" Text="取 消" />
                            </div>
                        </div>
                        <div class="MBottRight">
                        </div>
                    </div>
                </asp:Panel>
                <asp:GridView ID="ProductClassList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    OnPageIndexChanging="ProductClassList_PageIndexChanging" DataKeyNames="ProductClassId"
                    OnRowCancelingEdit="ProductClassList_RowCancelingEdit" OnRowEditing="ProductClassList_RowEditing"
                    OnRowUpdating="ProductClassList_RowUpdating" PageSize="11" OnRowDeleting="ProductClassList_RowDeleting"
                    CellPadding="0" CssClass="gv" Width="100%" OnRowDataBound="ProductClassList_RowDataBound">
                    <Columns>
                        <asp:BoundField DataField="ProductClassId" HeaderText="Id" ReadOnly="True" SortExpression="ProductClassId" />
                        <asp:BoundField DataField="OrderId" HeaderText="排序号">
                            <ControlStyle CssClass="gvOrderId" />
                        </asp:BoundField>
                        <asp:TemplateField HeaderText="分类名称">
                            <EditItemTemplate>
                                <asp:TextBox ID="ClassName" runat="server" Text='<%# Bind("ClassName") %>'></asp:TextBox>
                            </EditItemTemplate>
                            <ItemTemplate>
                                <asp:Label ID="Label5" runat="server" Text='<%# Bind("ClassNameText") %>'></asp:Label>
                                <asp:HiddenField ID="ParentIdHiddenField" runat="server" Value='<%# Bind("ParentId") %>' />
                            </ItemTemplate>
                            <ItemStyle CssClass="gvLeftField" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="分类标识">
                            <EditItemTemplate>
                                <asp:TextBox ID="FileName" runat="server" Text='<%# Bind("FileName") %>'></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="FileName"
                                    Display="Dynamic" ErrorMessage="必须填写"></asp:RequiredFieldValidator>
                                <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="FileName"
                                    Display="Dynamic" ErrorMessage="必须为小写字母或下划线组成" ValidationExpression="[a-z_]{0,50}"></asp:RegularExpressionValidator>
                                <asp:CustomValidator ID="ProductClassListCustomValidator" runat="server" ControlToValidate="FileName"
                                    Display="Dynamic" ErrorMessage="已存在此标识" OnServerValidate="ProductClassListCustomValidator_ServerValidate"></asp:CustomValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                <asp:Label ID="Label4" runat="server" Text='<%# Bind("FileName") %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作" ShowHeader="False">
                            <EditItemTemplate>
                                <asp:Button ID="UpdateBt" runat="server" CausesValidation="True" CommandName="Update"
                                    Text="更新" />
                                <asp:Button ID="CancelBt" runat="server" CausesValidation="False" CommandName="Cancel"
                                    Text="取消" />
                            </EditItemTemplate>
                            <ItemStyle CssClass="gvCommandField" />
                            <ItemTemplate>
                                <asp:Button ID="EditBt" runat="server" Text="编辑" CausesValidation="false" CommandName="Edit" />
                                <asp:Button ID="DelBt" runat="server" CausesValidation="False" CommandName="Delete"
                                    Text="删除" />
                                <ajaxToolkit:ConfirmButtonExtender ID="MyConfirmButtonExtender" runat="server" TargetControlID="DelBt"
                                    DisplayModalPopupID="ConfirmModalPopupExtender" />
                                <ajaxToolkit:ModalPopupExtender ID="ConfirmModalPopupExtender" runat="server" TargetControlID="DelBt"
                                    PopupControlID="MpePanel" PopupDragHandleControlID="TitlePanel" CancelControlID="CancelBt"
                                    OkControlID="OkBt" BackgroundCssClass="modalBackground" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <RowStyle CssClass="gvRow" />
                    <EditRowStyle CssClass="gvEditRow" />
                    <PagerStyle CssClass="gvPage" />
                    <HeaderStyle CssClass="gvHeader" />
                    <AlternatingRowStyle CssClass="gvAlternatingRow" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:UpdatePanel ID="AddProductClassUpdatePanel" UpdateMode="Conditional" runat="server">
            <ContentTemplate>
                <table width="100%" border="0" cellpadding="2" cellspacing="1" bgcolor="#D7D7D7"
                    id="mainBottTable">
                    <tr>
                        <td colspan="9" bgcolor="#FFFFFF" class="mainTitle">
                            添加分类&nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td align="right" bgcolor="#FFFFFF">
                            属于分类:
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:DropDownList ID="ClassList" runat="server">
                            </asp:DropDownList>
                        </td>
                        <td bgcolor="#FFFFFF" align="right">
                            &nbsp;排序号:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="OrderId" runat="server" Text="0" Width="20px" ValidationGroup="ClassAdd"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="OrderId"
                                ErrorMessage="排序号必须填写" Display="Dynamic" ValidationGroup="ClassAdd"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="OrderId"
                                Display="Dynamic" ErrorMessage="排序号应为正负整数" ValidationExpression="[-]{0,1}[0-9]+"
                                ValidationGroup="ClassAdd"></asp:RegularExpressionValidator>
                        </td>
                        <td bgcolor="#FFFFFF" align="right">
                            &nbsp;分类名称:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="ClassName" runat="server" CssClass="inputText"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="ClassName"
                                Display="Dynamic" ErrorMessage="必须填写" ValidationGroup="ClassAdd"></asp:RequiredFieldValidator>
                        </td>
                        <td bgcolor="#FFFFFF" align="right">
                            分类标识:
                        </td>
                        <td bgcolor="#FFFFFF">
                            &nbsp;<asp:TextBox ID="FileName" runat="server" CssClass="inputText"></asp:TextBox><asp:RequiredFieldValidator
                                ID="RequiredFieldValidator2" runat="server" ControlToValidate="FileName" Display="Dynamic"
                                ErrorMessage="必须填写" ValidationGroup="ClassAdd"></asp:RequiredFieldValidator><asp:RegularExpressionValidator
                                    ID="RegularExpressionValidator1" runat="server" ControlToValidate="FileName"
                                    Display="Dynamic" ErrorMessage="必须为小写字母或下划线组成" ValidationExpression="[a-z_]{0,30}"
                                    ValidationGroup="ClassAdd"></asp:RegularExpressionValidator><asp:CustomValidator
                                        ID="CustomValidator1" runat="server" ControlToValidate="FileName" Display="Dynamic"
                                        ErrorMessage="此标识已经存在" OnServerValidate="CustomValidator1_ServerValidate" ValidationGroup="ClassAdd"></asp:CustomValidator>
                        </td>
                        <td bgcolor="#ffffff">
                            <asp:Button ID="AddClass" runat="server" CssClass="inputBt" Text="添加分类" OnClick="AddClass_Click"
                                ValidationGroup="ClassAdd" />
                        </td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
</asp:Content>
