﻿<%@ page language="C#" autoeventwireup="true" inherits="phone_OrderMeal_CurrentOrderMeal, Web" %>

<%@ Register Src="~/phone/MyHeader.ascx" TagPrefix="uc1" TagName="MyHeader" %>
<%@ Register Src="~/phone/MyFooter.ascx" TagPrefix="uc1" TagName="MyFooter" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>学校网上订餐预约系统</title>
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/phone/css/style.css?v=201721" rel="stylesheet" />
    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
    <link href="/control/css/msgbox.css" rel="stylesheet" />
    <script src="/control/js/msgbox.js"></script>
    <style type="text/css">
        .l {
            font-weight: inherit;
        }
    </style>
</head>
<body>
    <uc1:MyHeader runat="server" ID="MyHeader" />
    <div class=" container-fluid ">
        <div class="row">
            <div class="col-xs-12 cont">
                <div class="panel panel-default">
                    <!-- Default panel contents -->
                    <div class="panel-heading">
                        <span style="font-weight: bold;">我的订餐详细
                        </span>
                    </div>

                    <div id="list" class="list-group" style="font-size: 15px;">
                        <asp:Repeater ID="rptData" runat="server">
                            <ItemTemplate>
                                <label class="list-group-item l " id="<%# Eval("om_id") %>">
                                    <span class="badge badge_1">
                                        <i class="glyphicon glyphicon-chevron-right"></i>
                                    </span>

                                    <input type="checkbox" value="<%# Eval("om_id") %>"  />

                                    <%#((DateTime)Eval("om_mdate")).ToString("ddd yyyy年MM月dd日") %>/<%# GetMClassName((int)Eval("om_mclass")) %>
                                </label>
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>

                </div>

            </div>
        </div>
    </div>


    <div class="container">
        <div class="row">
            <div class="col-xs-12">

                <div style="width: 100%; bottom: 0; position: fixed; right: 0; left: 0; z-index: 1030;">
                    <!-- Large modal -->
                    <div class="btn-group btn-group-justified" role="group" aria-label="...">

                        <div class="btn-group" role="group">
                            <button class="btn btn-primary btn-bm " type="button" onclick="cancelOM()">
                                <i class="glyphicon glyphicon-check"></i>
                                取消订餐
                            </button>
                        </div>

                        <div class="btn-group" role="group">
                            <a href="/phone/OrderMeal/OrderMeal.aspx" type="button" class="btn btn-default btn-bm ">
                                <i class="glyphicon glyphicon-plus"></i>
                                订餐</a>
                        </div>
                        <div class="btn-group" role="group">
                            <a href="/phone/OrderMeal/CurrentOrderMeal.aspx" type="button" class="btn btn-default btn-bm">
                                <i class="glyphicon glyphicon-th"></i>
                                我的订餐</a>
                        </div>

                         <div class="btn-group" role="group">
                         <a href="/phone/Notice/NoticeList.aspx" type="button" class="btn btn-default btn-bm">
                            <i class="glyphicon glyphicon-th-list"></i>
                            在线公告</a>
                        
                         </div>
       
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var startDate = '<%=sDate %>';
        var startMc = '<%=sMc %>';
        $(function () {
            $(":checkbox").change(function () {
                checkChange(this);
            });
        });

        function checkChange(obj) {
            if (obj.checked) {
                $(obj).parent().addClass("list-group-item-warning");
            } else {
                $(obj).parent().removeClass("list-group-item-warning");
            }
        }
        $(window).scroll(function () {
            if ($(document).scrollTop() >= $(document).height() - $(window).height()) {
                loadPageing();
            }
        });
        function loadPageing() {
            if (startDate != "") {
                ZENG.msgbox.show('加载中', 6);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    data: { "date": startDate, "mc": startMc },
                    success: function (result) {

                        startDate = result.mdate;
                        startMc = result.mc;

                        var list = result.list;
                        var l = list.length;
                        var sb = new StringBuilder();
                        for (var i = 0; i < l; i++) {
                            var item = list[i]
                            sb.append("<label class='list-group-item l' id='" + item.id + "'>");
                            sb.append("<span class='badge badge_1'>");
                            sb.append("<i class='glyphicon glyphicon-chevron-right'></i>");
                            sb.append("</span>");
                            sb.append(" <input type='checkbox' value='" + item.id + "' onchange='checkChange(this)' />")
                            sb.append(item.date);
                            sb.append('/');
                            sb.append(item.class);
                            sb.append("</label>");
                        }
                        $("#list").append(sb.tostring());
                        ZENG.msgbox._hide();
                    }
                });
            }
        }

        function cancelOM() {
            var list = $("#list").find(":checked");
            if (list.size()==0) {
                alert("请选择取消的订餐！");
                return;
            }
            if (confirm("确定要取消这" + list.size() + "次订餐吗？")) {
                var dlist = new Array();
                for (var i = 0; i < list.size() ; i++) {
                    var item = list.eq(i);
                    dlist.push(item.val());
                }
                ZENG.msgbox.show('订餐取消中...', 6);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    data: { "dlist": dlist.join(',') },
                    success: function (result) {
                        ZENG.msgbox._hide();
                        if (result.state == 1) {
                            var rlist = result.data.split(',');
                            for (var i = 0; i < rlist.length; i++) {
                                $("#" + rlist[i]).remove();
                            }

                            alert("已取消" + rlist.length + "次订餐 （注：请在订餐截止时间内取消预订）");
                        }
                    }
                });
            }
        }

        function StringBuilder() {
            this.__strings__ = new Array;

            if (typeof StringBuilder._initialized == "undefined") {
                StringBuilder.prototype.append = function (str) {
                    this.__strings__.push(str);
                };

                StringBuilder.prototype.prvAppend = function (str) {
                    this.__strings__.unshift(str);
                };

                StringBuilder.prototype.tostring = function () {
                    return this.__strings__.join("");
                };
                StringBuilder._initialized = true;
            }
        }
        //------------------Format---------------------------
        String.prototype.format = function () {
            var args = arguments;
            return this.replace(/\{(\d+)\}/g,
                function (m, i) {
                    return args[i];
                });
        }
        String.format = function () {
            if (arguments.length == 0)
                return null;

            var str = arguments[0];
            for (var i = 1; i < arguments.length; i++) {
                var re = new RegExp('\\{' + (i - 1) + '\\}', 'gm');
                str = str.replace(re, arguments[i]);
            }
            return str;
        }

    </script>
</body>
</html>
