﻿<%@ page language="C#" autoeventwireup="true" inherits="sys_Meal_Meal, Web" %>

<%@ Register Src="~/sys/MyHeader.ascx" TagPrefix="uc1" TagName="MyHeader" %>
<%@ Register Src="~/sys/MyFooter.ascx" TagPrefix="uc1" TagName="MyFooter" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>报餐系统</title>
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/sys/css/style.css?v=201721" rel="stylesheet" />
    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
    <script src="/control/plugin/My97DatePicker/WdatePicker.js"></script>
    <link href="/control/css/msgbox.css" rel="stylesheet" />
    <script src="/control/js/msgbox.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/locales/bootstrap-datepicker.zh-CN.js"></script>
    <link href="/control/plugin/bootstrap-datepicker/css/datepicker3.css" rel="stylesheet" />
</head>
<body>
    <uc1:MyHeader runat="server" ID="MyHeader" />
    <div class="container-fluid">
        <ul class="nav nav-tabs" role="tablist">
            <li id="mc1" role="presentation"><a href="Meal.aspx?type=1">早餐</a></li>
            <li id="mc2" role="presentation"><a href="Meal.aspx?type=2">午餐</a></li>
            <li id="mc3" role="presentation"><a href="Meal.aspx?type=3">晚餐</a></li>
        </ul>
        <script type="text/javascript">
            $("#mc<%=mclass %>").addClass("active");
        </script>
        <br />
        <div class="row">
            <div class="col-lg-12">
                <div class="panel">
                    <div class="panel-body">
                        <div class="row" style="font-size: 20px;">
                            <div class="col-xs-5 text-danger">
                                <button type="button" class="btn btn-default" onclick="add()">
                                    <i class="glyphicon glyphicon-plus"></i>添加菜品
                                </button>
                            </div>
                            <div class="col-xs-7 text-success"> 
                            </div>
                        </div>

                    </div>
                </div>
                <div class="panel">
                    <div class="panel-body">
                        <table id="dataView" class="table table-hover table-striped ">
                          
                            <thead>
                                <tr class='table-heading'>
                                    <th>序号</th>
                                    <th>菜品</th>
                                    <th>类型</th>
                                    <th>状态</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <asp:Repeater ID="rptData" runat="server">

                                    <ItemTemplate>
                                        <tr>
                                            <td><%#Eval("rowNum") %></td>
                                            <td>
                                                <%#Eval("m_name")%>
                                            </td>
                                            <td>
                                                <%#Eval("m_type")%>
                                            </td>
                                            <td>
                                                <%#Eval("m_state").ToString()=="1"?"提供中":"暂停提供"%>
                                            </td>

                                            <td>
                                                <button onclick="edit('<%#Eval("m_id") %>')" class="btn btn-default btn-xs" type="button">
                                                    编辑
                                                </button>
                                                <button class="btn btn-default btn-xs" type="button" onclick="rd('<%#Eval("m_id") %>')">
                                                    删除
                                                </button>
                                            </td>
                                        </tr>
                                    </ItemTemplate>

                                </asp:Repeater>
                            </tbody>
                        </table>
                        <asp:Literal ID="litPage" runat="server"></asp:Literal>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <uc1:MyFooter runat="server" ID="MyFooter" />

        <script type="text/javascript">

        function add() {
            $("#iframeContent").hide();
            $("#iframeContent").attr("src", "/sys/Meal/Meal_Add.aspx");
            $("#OperDialog").modal({ backdrop :false});
            $("#operTitle").text("添加");
        }
        function edit(id) {

            $("#iframeContent").hide();
            $("#iframeContent").attr("src", "/sys/Meal/Meal_Edit.aspx?id=" + id);
            $("#OperDialog").modal({ backdrop: false });
            $("#operTitle").text("编辑");
        }
        function reload() {
            window.location.reload();
        }
        function ShowDialog() {
            $("#iframeContent").show();
        }
        function rd(key) {
            if (confirm('确定删除该项！')) {
                ZENG.msgbox.show('删除中...', 6);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    data: { "did": key },
                    success: function (result) {
                        ZENG.msgbox._hide();
                        if (result.state == 1) {
                            location.reload();
                        } else {
                            alert(result.data);
                        }
                    }
                });
            }
        }
    </script>
    <div class="modal" id="OperDialog" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel" >
        <div class="modal-dialog  " role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="operTitle"></h4>
                </div>
                <div class="modal-body">
                    <div style="height: 595px">
                        <iframe id="iframeContent" width="100%" height="590" frameborder="0" style="display: none"></iframe>
                    </div>
                    <!-- Table -->
                </div>
            </div>
        </div>
    </div>
</body>
</html>
