﻿<%@ page language="C#" autoeventwireup="true" inherits="sys_Meal_Meal_Add, Web" %>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>江门市新会梁启超纪念中学食堂报餐系统</title>
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />
    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
        <script src="/control/plugin/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/locales/bootstrap-datepicker.zh-CN.js"></script>
        <link href="/control/plugin/bootstrap-datepicker/css/datepicker3.css" rel="stylesheet" />
    <style>
        .l {
            font-weight: initial;
        }
        .rd{
            color:red;
        }
    </style>
</head>
<body>
    <form id="from1" runat="server">
        <div class="form-group">
            <label class="control-label">
                菜品名称<span class='rd'>*</span>：
                <asp:RequiredFieldValidator ID="rfvt_name" runat="server" ForeColor="Red" ErrorMessage="请填写"
                    ControlToValidate="txtt_name"></asp:RequiredFieldValidator>
                 <asp:RegularExpressionValidator ID="revUser" runat="server" ErrorMessage="1到50字内" 
                    Display="Dynamic" ForeColor="Red" ControlToValidate="txtt_name" 
                    ValidationExpression="^.{1,50}$"></asp:RegularExpressionValidator>
            </label>
            <asp:TextBox ID="txtt_name" runat="server" MaxLength="50" CssClass="form-control"></asp:TextBox>
        </div>

        <div class="form-group">
            菜品类型<span class='rd'>*</span>：
            <asp:CheckBoxList ID="chk_type" runat="server">
                <asp:ListItem Value="早餐">早餐</asp:ListItem>
                <asp:ListItem Value="午餐">午餐</asp:ListItem>
                <asp:ListItem Value="晚餐">晚餐</asp:ListItem>
            </asp:CheckBoxList>
        </div>
        <div class="form-group">
            <label class=" control-label">
                状态<span class='rd'>*</span>：<asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server"
                    ForeColor="Red" ErrorMessage="请选择"
                    ControlToValidate="rbt_state"></asp:RequiredFieldValidator>
               <asp:RadioButtonList ID="rbt_state" runat="server">
                   <asp:ListItem Value="1">提供</asp:ListItem>
                   <asp:ListItem Value="0">暂不提供</asp:ListItem>
               </asp:RadioButtonList>
               

            </label>            
        </div>

        <div class="form-group">
            <asp:Button ID="btnSubmit" runat="server" Text="添加菜品" OnClientClick="return check()"
                CssClass="btn  btn-primary btn-block"
                OnClick="btnSubmit_Click" />
        </div>

    </form>

    <script type="text/javascript">
        $(function () {
            window.parent.ShowDialog();
        });
        function check()
        {
            if (!Page_ClientValidate())
                return false;
            var count = $("#chk_type input[type='checkbox']").length;
            if(count==0)
            {
                alert("请选择菜品类型");
                return false;
            }
            return true;
        }
    </script>
</body>
</html>