﻿<%@ page language="C#" autoeventwireup="true" validaterequest="false" inherits="sys_Notice_NoticeList, Web" %>

<%@ Register Src="~/sys/MyHeader.ascx" TagPrefix="uc1" TagName="MyHeader" %>
<%@ Register Src="~/sys/MyFooter.ascx" TagPrefix="uc1" TagName="MyFooter" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>学校网上订餐预约系统</title>
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/sys/css/style.css?v=201721" rel="stylesheet" />
    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
    <script src="/control/plugin/My97DatePicker/WdatePicker.js"></script>
    <link href="/control/css/msgbox.css" rel="stylesheet" />
    <script src="/control/js/msgbox.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/locales/bootstrap-datepicker.zh-CN.js"></script>
    <link href="/control/plugin/bootstrap-datepicker/css/datepicker3.css" rel="stylesheet" />
</head>
<body>
    <uc1:MyHeader runat="server" ID="MyHeader" />
    <div class=" container-fluid">
        <div class="row">
            <div class="col-xs-12 ">
                <h3 class="page-header">在线公告<small></small></h3>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="well">
                    <form class="form-inline" method="get">

                        <div class="form-group">
                            <label for="txtstart">标题:</label>
                            <input type="text" class="form-control" id="txtName" name="name" value="<%=Request["name"] %>" />
                        </div>

                        <button type="submit" class="btn btn-default">查询</button>
                        <button type="button" class="btn btn-default" onclick="add()">
                            <i class="glyphicon glyphicon-plus"></i>添加
                        </button>
                    </form>
                </div>
                <div class="panel panel-default">
                    <div class="panel-body">
                        <asp:Repeater ID="rptData" runat="server">
                            <HeaderTemplate>
                                <table id="dataView" class="table table-hover table-striped  ">
                                    <thead>
                                        <tr class='table-heading'>
                                            <th>序号</th>
                                            <th>标题</th>
                                            <th>日期</th>
                                            <th>修改时间</th>                                          
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <tr>

                                    <td>
                                        <%#Eval("rowNum") %>
                                    </td>
                                    <td>
                                        <%#Eval("n_title")%>
                                    </td>                                   
                                    <td>
                                        <%#Eval("n_date","{0:yyyy-MM-dd}")%>
                                    </td>
                                    <td>
                                        <%#Eval("n_udate","{0:yyyy-MM-dd HH:mm}")%>
                                    </td>
                                    <td>
                                        <button onclick="edit('<%#Eval("n_id") %>')" class="btn btn-default btn-xs" type="button">
                                            编辑
                                        </button>
                                        <button class="btn btn-default btn-xs" type="button" onclick="rd('<%#Eval("n_id") %>')">
                                            删除
                                        </button>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <FooterTemplate>
                                </tbody> </table>
                            </FooterTemplate>
                        </asp:Repeater>
                    </div>

                    <%-- <div class="panel-footer">--%>
                    <%--</div>--%>
                </div>
                <asp:Literal ID="litPage" runat="server"></asp:Literal>
            </div>
        </div>
    </div>
    <uc1:MyFooter runat="server" ID="MyFooter" />

    <script type="text/javascript">

        function add() {
            $("#iframeContent").hide();
            $("#iframeContent").attr("src", "/sys/Notice/NoticeAdd.aspx");
            $("#OperDialog").modal({ backdrop :false});
            $("#operTitle").text("添加");
        }
        function edit(id) {

            $("#iframeContent").hide();
            $("#iframeContent").attr("src", "/sys/Notice/NoticeEdit.aspx?id=" + id);
            $("#OperDialog").modal({ backdrop: false });
            $("#operTitle").text("编辑");
        }
        function reload() {
            window.location.reload();
        }
        function ShowDialog() {
            $("#iframeContent").show();
        }
        function rd(key) {
            if (confirm('确定删除该项！')) {
                ZENG.msgbox.show('删除中...', 6);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    data: { "did": key },
                    success: function (result) {
                        ZENG.msgbox._hide();
                        if (result.state == 1) {
                            location.reload();
                        } else {
                            alert(result.data);
                        }
                    }
                });
            }
        }
    </script>
    <div class="modal" id="OperDialog" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel" >
        <div class="modal-dialog  modal-lg" role="document">
            <div class="modal-content modal-lg">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="operTitle"></h4>
                </div>
                <div class="modal-body">
                    <div style="height: 595px">
                        <iframe id="iframeContent" width="100%" height="590" frameborder="0" style="display: none"></iframe>
                    </div>
                    <!-- Table -->
                </div>
            </div>
        </div>
    </div>

</body>
</html>