﻿<%@ page language="C#" autoeventwireup="true" inherits="sys_UpdatePass, Web" %>

<%@ Register Src="~/sys/MyHeader.ascx" TagPrefix="uc1" TagName="MyHeader" %>
<%@ Register Src="~/sys/MyFooter.ascx" TagPrefix="uc1" TagName="MyFooter" %>


<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>修改密码</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />

    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
    <link href="/sys/css/style.css?v=201721" rel="stylesheet" />
        <script src="/control/plugin/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/locales/bootstrap-datepicker.zh-CN.js"></script>
    <link href="/control/plugin/bootstrap-datepicker/css/datepicker3.css" rel="stylesheet" />
    <style>
         .rd{
            color:red;
        }
    </style>
</head>
<body>
    <uc1:MyHeader runat="server" ID="MyHeader" />
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="page-header">密码修改<small> 修改管理员的账号和密码 </small></h3>
                <div class="panel panel-default" style="margin-top: 10px">
                    <div class="panel-body">
                        <form id="from1" runat="server">
                            <!-- Add.aspx -->
                            <div class="form-group">
                                <label class=" control-label">
                                    用户名<span class='rd'>*</span>
                                    <asp:RequiredFieldValidator ID="rfvsa_user" runat="server" ForeColor="Red" ErrorMessage="请填写用户名"  Display="Dynamic"
                                        ControlToValidate="txtsa_user"></asp:RequiredFieldValidator>：</label>
                                <div>
                                    <asp:TextBox ID="txtsa_user" runat="server" MaxLength="255" CssClass="form-control"></asp:TextBox>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class=" control-label">
                                    密码<span class='rd'>*</span>
                                    <asp:RequiredFieldValidator ID="rfvsa_pass" runat="server" ForeColor="Red" ErrorMessage="请填写密码" Display="Dynamic"
                                        ControlToValidate="txtsa_pass"></asp:RequiredFieldValidator>：</label>
                                <div>
                                    <asp:TextBox ID="txtsa_pass" runat="server" MaxLength="255" CssClass="form-control"
                                        TextMode="Password"></asp:TextBox>

                                </div>

                            </div>
                            <hr />
                            <div class="form-group">
                                <label class=" control-label">
                                    新用户名<span class='rd'>*</span>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ForeColor="Red" Display="Dynamic"
                                        ErrorMessage="请填写用户名" ControlToValidate="txtNewUser"></asp:RequiredFieldValidator>
                                    
                                      <asp:RegularExpressionValidator ID="revUser" runat="server" ErrorMessage="只允许数字字母@_."  Display="Dynamic"
                                          ControlToValidate="txtNewUser" ValidationExpression="^[0-9a-zA-z_@]{1,50}$" ForeColor="Red"> 
                                      </asp:RegularExpressionValidator>：</label>
                                <div>

                                    <asp:TextBox ID="txtNewUser" runat="server" MaxLength="255" CssClass="form-control"></asp:TextBox>

                                </div>

                            </div>

                            <div class="form-group">
                                <label class=" control-label">
                                    新密码<span class='rd'>*</span>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ForeColor="Red" Display="Dynamic"
                                        ErrorMessage="请填写密码" ControlToValidate="txtNewPass"></asp:RequiredFieldValidator>：</label>
                                <div>
                                    <asp:TextBox ID="txtNewPass" runat="server" MaxLength="255" CssClass="form-control"
                                        TextMode="Password"></asp:TextBox>

                                </div>
                            </div>

                            <div class="form-group">
                                <label class=" control-label">
                                    新密码验证<span class='rd'>*</span>
                                    <asp:CompareValidator ID="CompareValidator1" runat="server"
                                        ControlToCompare="txtNewPass2" ControlToValidate="txtNewPass" Display="Dynamic"
                                        ErrorMessage="两次密码输入不一致" ForeColor="Red"></asp:CompareValidator>：</label>
                                <div>
                                    <asp:TextBox ID="txtNewPass2" runat="server" MaxLength="255" CssClass="form-control"
                                        TextMode="Password"></asp:TextBox>
                                </div>
                            </div>

                            <div class="form-group">
                                <asp:Button ID="btnSubmit" runat="server" Text="修改密码"  CssClass="btn btn-block  btn-primary btn-lg" OnClick="btnSubmit_Click" />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
</body>
</html>

