﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Security;
namespace ShanPlay
{
    public class Parms
    {
        /// <summary>
        /// 云通付PID(必填)
        /// </summary>
        public string partner { get; set; }
        /// <summary>
        /// 云通付商户号(必填)
        /// </summary>
        public string user_seller { get; set; }
        /// <summary>
        /// 商户网站订单号（唯一）(必填)
        /// </summary>
        public string out_order_no { get; set; }
        /// <summary>
        /// 订单名称(必填)
        /// </summary>
        public string subject { get; set; }
        /// <summary>
        /// 订单价格（整元）(必填)
        /// </summary>
        public string total_fee { get; set; }
        /// <summary>
        /// 订单描述(选填)
        /// </summary>
        public string body { get; set; }
        /// <summary>
        /// 异步回调地址(必填)
        /// </summary>
        public string notify_url { get; set; }
        /// <summary>
        /// 同步回调地址(必填)
        /// </summary>
        public string return_url { get; set; }
        /// <summary>
        /// 密钥
        /// </summary>
        public string Key { get; set; }

      
        public string Parm
        {
            get
            {
                string prestr = string.Empty;
                if (!string.IsNullOrEmpty(body))
                {
                    prestr += "body=" + body + "&";
                }
                prestr += "notify_url=" + notify_url + "&";
                prestr += "out_order_no=" + out_order_no + "&";
                prestr += "partner=" + partner + "&";
                prestr += "return_url=" + return_url + "&";
                prestr += "subject=" + subject + "&";
                prestr += "total_fee=" + total_fee + "&";
                prestr += "user_seller=" + user_seller;
                return prestr;
            }
        }
        /// <summary>
        /// 校验码(必填)
        /// </summary>
        public string sign { get { return Md5.md5(Parm+Key); } }
        public string UrlParm { get { return Parm +"&sign="+sign; } }
    }
}
