﻿// ajax.js latest modified by Layy 2014-07-01

var xmlHttp, xmlHttpTitle, xmlHttpRun, IE, isSupportOnHashChange;

function createXMLHttpRequest() {
    if (window.ActiveXObject) {
        xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
        xmlHttpTitle = new ActiveXObject("Microsoft.XMLHTTP");
        xmlHttpRun = new ActiveXObject("Microsoft.XMLHTTP");
    }
    else if (window.XMLHttpRequest) {
        xmlHttp = new XMLHttpRequest();
        xmlHttpTitle = new XMLHttpRequest();
        xmlHttpRun = new XMLHttpRequest();
    }
    else {
        alert("Create XMLHttpRequest object error...");
    }
}

function isNewVersionIE() {
    var ua = navigator.userAgent.toLowerCase();
    if (window.ActiveXObject)
        IE = ua.match(/msie ([\d.]+)/)[1];
    if (IE == "6.0" || IE == "7.0") {
        return false;
    }
    else return true;
}

// Article
function callBackArticleHandler() {
    if (xmlHttp.readyState == 4) {
        if (xmlHttp.status == 200) {
            printf("innerContent", xmlHttp.responseText);
        }
    }
}

function getData(url) {
    if (xmlHttp) {
        openTip();
        xmlHttp.open("get", url, true);
        xmlHttp.onreadystatechange = callBackArticleHandler;
        xmlHttp.send(null);
        setTimeout("closeTip()", 1500);
    }
    refreshRun();
}

function toArticle(id) {
    if (!isSupportOnHashChange) { ajaxArticle(id); }
    window.location.hash = "#article_id{" + id + "}";
}

function ajaxArticle(id) {
    scroll(0, 0);
    var url = "ajax.aspx?type=article_id&id=" + id + "&comment_parentid=" + id + "&comment_page=1&p=" + Math.random();
    getData(url);
    getTitle();
}

function toPage(id, page) {
    if (!isSupportOnHashChange) { ajaxPage(id, page); }
    window.location.hash = "#article_page{" + page + "}";
}

function ajaxPage(id, page) {
    scroll(0, 0);
    var url;
    if (getCookie("ViewMode") == "Normal") {
        url = "ajax.aspx?type=article&page=" + page + "&p=" + Math.random();
    }
    else {
        url = "ajax.aspx?type=list&page=" + page + "&p=" + Math.random();
    }
    getData(url);
    getTitle();
}

function toCategory(categoryid, page) {
    if (!isSupportOnHashChange) { ajaxCategory(categoryid, page); }
    window.location.hash = "#article_category{" + categoryid + "}#page[" + page + "]";
}

function ajaxCategory(categoryid, page) {
    scroll(0, 0);
    var url;
    if (getCookie("ViewMode") == "Normal") {
        url = "ajax.aspx?type=article_category&categoryid=" + categoryid + "&page=" + page + "&p=" + Math.random();
    }
    else {
        url = "ajax.aspx?type=list_category&categoryid=" + categoryid + "&page=" + page + "&p=" + Math.random();
    }
    getData(url);
}

function toDate(date, page) {
    if (!isSupportOnHashChange) { ajaxDate(date, page); }
    window.location.hash = "#article_date{" + date + "}#page[" + page + "]";
}

function ajaxDate(date, page) {
    scroll(0, 0);
    var url;
    if (getCookie("ViewMode") == "Normal") {
        url = "ajax.aspx?type=article_date&date=" + date + "&page=" + page + "&p=" + Math.random();
    }
    else {
        url = "ajax.aspx?type=list_date&date=" + date + "&page=" + page + "&p=" + Math.random();
    }
    getData(url);
}
// End Article


// Comment
function callBackCommentHandler() {
    if (xmlHttp.readyState == 4) {
        if (xmlHttp.status == 200) {
            printf("commentWrapper", xmlHttp.responseText);
        }
    }
}

function getComment(url) {
    if (xmlHttp) {
        openCommentTip();
        xmlHttp.open("get", url, true);
        xmlHttp.onreadystatechange = callBackCommentHandler;
        xmlHttp.send(null);
        setTimeout("closeCommentTip()", 1000);
    }
    refreshRun();
}

function toComment(parentid, page) {
    if (!isSupportOnHashChange) { ajaxComment(parentid, page); }
    window.location.hash = "#comment{" + parentid + "}#page[" + page + "]";
}

function ajaxComment(parentid, page) {
    var url = "ajax.aspx?type=comment&comment_parentid=" + parentid + "&comment_page=" + page + "&p=" + Math.random();
    getComment(url);
}

function postComment(parentid) {
    var username = document.getElementById("username").value.trim();
    var blogurl = document.getElementById("blogurl").value.trim();
    if (blogurl.indexOf("http://") == -1) {
        blogurl = "http://" + blogurl;
    }
    var vcode = document.getElementById("vcode").value.trim();
    var message = document.getElementById("message").value.trim();

    if (document.getElementById("c_ubb").checked == true) {
        var isubb = true;
    }
    if (document.getElementById("c_autourl").checked == true) {
        var isautourl = true;
    }
    if (document.getElementById("c_emote").checked == true) {
        var isemote = true;
    }

    var url = "ajax.aspx?type=post_comment&comment_parentid=" + parentid;
    var data = "username=" + escape(username) + "&blogurl=" + escape(blogurl) + "&vcode=" + escape(vcode) + "&message=" + escape(message) + "&c_ubb=" + escape(isubb) + "&c_autourl=" + escape(isautourl) + "&c_emote=" + escape(isemote);
    postData(url, data, callBackCommentHandler);
    resetForm();
}

function postData(url, data, handler) {
    if (xmlHttp) {
        openTip();
        xmlHttp.open("post", url, true);
        xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xmlHttp.onreadystatechange = handler;
        xmlHttp.send(data);
        setTimeout("closeTip()", 1500);
    }
}
// End Comment


// Tag
function getTags() {
    if (!isSupportOnHashChange) { ajaxTags(); }
    window.location.hash = "#tags";
}

function ajaxTags() {
    scroll(0, 0);
    var url = "ajax.aspx?type=tag&p=" + Math.random();
    getData(url);
}

function toTag(tagid, page) {
    if (!isSupportOnHashChange) { ajaxTag(tagid, page); }
    window.location.hash = "#article_tag{" + tagid + "}#page[" + page + "]";
}

function ajaxTag(tagid, page) {
    scroll(0, 0);
    var url = "ajax.aspx?type=article_tag&tagid=" + tagid + "&page=" + page + "&p=" + Math.random();
    getData(url);
}
// End Tag


// SearchField
function chkSearch() {
    var text = document.getElementById("searchField").value.trim();
    if (text == "") {
        alert("Search Field has not filled.");
        return false;
    }
    else {
        toSearchResult(document.getElementById('searchField').value.trim(), 1);
        return true;
    }
}

function toSearchResult(text, page) {
    if (!isSupportOnHashChange) { ajaxSearchResult(text, page); }
    window.location.hash = "#search{" + text + "}#page[" + page + "]";
}

function ajaxSearchResult(text, page) {
    scroll(0, 0);
    var url = "ajax.aspx?type=search&title=" + text + "&page=" + page + "&p=" + Math.random();
    getData(url);
}
// End SearchField


// GuestBook
function toGuestBook(id, page) {
    if (!isSupportOnHashChange) { ajaxGuestBook(id, page); }
    window.location.hash = "#guestbook{" + page + "}";
}

function ajaxGuestBook(id, page) {
    scroll(0, 0);
    var url = "ajax.aspx?type=guestbook&page=" + page + "&p=" + Math.random();
    getData(url);
}

function postMessage() {
    var errMessage, bError, theForm, url, data;
    errMessage = "Some Required Field has not filled.";
    bError = false;

    var username = document.getElementById("username").value.trim();
    var blogurl = document.getElementById("blogurl").value.trim();
    var vcode = document.getElementById("vcode").value.trim();
    var message = document.getElementById("message").value.trim();

    if (username == "") {
        errMessage += "\n - Please input the username";
        bError = true;
    }
    if (blogurl.indexOf("http://") == -1) {
        blogurl = "http://" + blogurl;
    }
    if (!isURL(blogurl) && blogurl.trim() != "http://")  // !=（不带类型判断的）或者!==（严格类型判断）   
    {
        errMessage += "\n - Please input the right url";
        bError = true;
    }
    if (vcode == "") {
        errMessage += "\n - Please input the validate code";
        bError = true;
    }
    if (vcode.len() < 4) {
        errMessage += "\n - It is not enough to input figure number of characters";
        bError = true;
    }
    if (message == "") {
        errMessage += "\n - Please input the content";
        bError = true;
    }
    if (bError) {
        alert(errMessage);
        return false;
    }
    else {
        if (document.getElementById("c_ubb").checked == true) {
            var isubb = true;
        }
        if (document.getElementById("c_autourl").checked == true) {
            var isautourl = true;
        }
        if (document.getElementById("c_emote").checked == true) {
            var isemote = true;
        }
        scroll(0, 0);
        url = "ajax.aspx?type=post_message&p=" + Math.random();
        data = "username=" + escape(username) + "&blogurl=" + escape(blogurl) + "&vcode=" + escape(vcode) + "&message=" + escape(message) + "&c_ubb=" + escape(isubb) + "&c_autourl=" + escape(isautourl) + "&c_emote=" + escape(isemote);

        postData(url, data, callBackMessageHandler);
        resetForm();
        return true;
    }
}

function callBackMessageHandler() {
    if (xmlHttp.readyState == 4) {
        if (xmlHttp.status == 200) {
            var response = xmlHttp.responseText;
            if (response == "0") {
                alert("Your post is fail");
            }
            else {
                printf("innerContent", xmlHttp.responseText);
            }
        }
    }
}
// End GuestBook


// UserInfo
function getUserInfo() {
    if (!isSupportOnHashChange) { ajaxUserInfo(); }
    window.location.hash = "#info";
}

function ajaxUserInfo() {
    scroll(0, 0);
    var url = "ajax.aspx?type=about&p=" + Math.random();
    getData(url);
}
// End UserInfo


// Album
function getAlbum() {
    if (!isSupportOnHashChange) { ajaxAlbum(); }
    window.location.hash = "#album_all";
}

function ajaxAlbum() {
    scroll(0, 0);
    var url = "ajax.aspx?type=album&p=" + Math.random();
    getData(url);
}

function toAlbumPage(id, page) {
    if (!isSupportOnHashChange) { ajaxAlbumPage(id, page); }
    if (getCookie("AlbumMode") == "Normal") {
        window.location.hash = "#album_all";
    }
    else {
        window.location.hash = "#album_page{" + page + "}";
    }
}

function ajaxAlbumPage(id, page) {
    scroll(0, 0);
    var url;
    if (getCookie("AlbumMode") == "Normal") {
        url = "ajax.aspx?type=album&p=" + Math.random();
    }
    else {
        url = "ajax.aspx?type=album_page&page=" + page + "&p=" + Math.random();
    }
    getData(url);
}

function toAlbumCategory(albumcategoryid, page) {
    if (!isSupportOnHashChange) { ajaxAlbumCategory(albumcategoryid, page); }
    window.location.hash = "#album_category{" + albumcategoryid + "}#page[" + page + "]";
}

function ajaxAlbumCategory(albumcategoryid, page) {
    scroll(0, 0);
    var url = "ajax.aspx?type=album_category&album_category_id=" + albumcategoryid + "&page=" + page + "&p=" + Math.random();
    getData(url);
}
// End Album


// Photo
function callBackPhotoHandler() {
    if (xmlHttp.readyState == 4) {
        if (xmlHttp.status == 200) {
            printf("innerContent", xmlHttp.responseText);
            try {
                initGallery(); // 尝试加载相册
            }
            catch (err) {

            }
        }
    }
}

function getPhotoData(url) {
    if (xmlHttp) {
        openTip();
        xmlHttp.open("get", url, true);
        xmlHttp.onreadystatechange = callBackPhotoHandler;
        xmlHttp.send(null);
        setTimeout("closeTip()", 1500);
    }
    refreshRun();
}

function toPhoto(albumid) {
    if (!isSupportOnHashChange) { ajaxPhoto(albumid); }
    window.location.hash = "#photo_album{" + albumid + "}";
}

function ajaxPhoto(albumid) {
    scroll(0, 0);
    var url = "ajax.aspx?type=photo&album_id=" + albumid + "&p=" + Math.random();
    getPhotoData(url);
}
// End Photo


// Login
function postLoginData(url, data, handler) {
    if (xmlHttp) {
        xmlHttp.open("post", url, true);
        xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xmlHttp.onreadystatechange = handler;
        xmlHttp.send(data);
    }
}

function login() {
    var errMessage, bError, url, data;
    errMessage = "Some Required Field has not filled.";
    bError = false;

    var loginname = document.getElementById("loginname").value.trim();
    var password = document.getElementById("password").value.trim();
    var validatecode = document.getElementById("validatecode").value.trim();

    if (loginname == "") {
        errMessage += "\n - Please input your username";
        bError = true;
    }
    if (password == "") {
        errMessage += "\n - Please input your password";
        bError = true;
    }
    if (validatecode == "") {
        errMessage += "\n - Please input the validate code";
        bError = true;
    }
    if (validatecode.len() < 4) {
        errMessage += "\n - It is not enough to input figure number of characters";
        bError = true;
    }
    if (bError) {
        alert(errMessage);
        return false;
    }
    else {
        // scroll(0,0);
        url = "manager/ajax.aspx?type=login&p=" + Math.random();
        data = "loginname=" + escape(loginname) + "&password=" + escape(password) + "&validatecode=" + escape(validatecode);
        postLoginData(url, data, callBackLoginHandler);
        return true;
    }
}

function callBackLoginHandler() {
    if (xmlHttp.readyState == 4) {
        if (xmlHttp.status == 200) // 怎么要加上这个||xmlHttp.status==0
        {
            var response = xmlHttp.responseText;
            if (response == 0) {
                alert(" Login is fail!\n Please check your password or change your validate code.");
            }
            else {
                redirect("manager/index.aspx");
            }
        }
    }
}
// End Login


// Article Title
function callBackTitleInfoHandler() {
    if (xmlHttpTitle.readyState == 4) {
        if (xmlHttpTitle.status == 200) {
            document.title = xmlHttpTitle.responseText;
        }
    }
}

function getTitle() {
    var url = "ajax.aspx?type=article_title&p=" + Math.random();
    if (xmlHttpTitle) {
        xmlHttpTitle.open("get", url, true);
        xmlHttpTitle.onreadystatechange = callBackTitleInfoHandler;
        xmlHttpTitle.send(null);
    }
}
// End Article Title


// Run Info
function callBackRunInfoHandler() {
    if (xmlHttpRun.readyState == 4) {
        if (xmlHttpRun.status == 200) {
            printf("run", xmlHttpRun.responseText);
        }
    }
}

function refreshRun() {
    var url = "ajax.aspx?type=run&p=" + Math.random();
    if (xmlHttpRun) {
        xmlHttpRun.open("get", url, true);
        xmlHttpRun.onreadystatechange = callBackRunInfoHandler;
        xmlHttpRun.send(null);
    }
}
// End Run Info


// Tip
function openTip() {
    reveal("tip");
}

function closeTip() {
    hide("tip");
}

function openCommentTip() {
    reveal("commentTip");
}

function closeCommentTip() {
    hide("commentTip");
}
// End Tip


// Hash Address
function hash() {

    var hash = (window.location.hash == null) ? window.location.hash = "#article_page{1}" : window.location.hash;
    if (window.location.hash != null) {

        var hash = window.location.hash;

        if (hash.indexOf("article_id") > 0) {
            var article_id = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            ajaxArticle(article_id);
            return;
        }

        if (hash.indexOf("article_page") > 0) {
            var article_page = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            ajaxPage(-1, article_page);
            return;
        }

        if (hash.indexOf("article_category") > 0) {
            var article_category = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            var article_category_page = hash.substring(hash.indexOf("[") + 1, hash.indexOf("]"));
            ajaxCategory(article_category, article_category_page);
            return;
        }

        if (hash.indexOf("article_date") > 0) {
            var article_date = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            var article_date_page = hash.substring(hash.indexOf("[") + 1, hash.indexOf("]"));
            ajaxDate(article_date, article_date_page);
            return;
        }

        if (hash.indexOf("article_tag") > 0) {
            var article_tag = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            var article_tag_page = hash.substring(hash.indexOf("[") + 1, hash.indexOf("]"));
            ajaxTag(article_tag, article_tag_page);
            return;
        }

        if (hash.indexOf("search") > 0) {
            var article_search = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            var article_search_page = hash.substring(hash.indexOf("[") + 1, hash.indexOf("]"));
            ajaxSearchResult(article_search, article_search_page);
            return;
        }

        if (hash.indexOf("comment") > 0) {
            var parent = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            var comment_page = hash.substring(hash.indexOf("[") + 1, hash.indexOf("]"));
            ajaxComment(parent, comment_page);
            return;
        }

        if (hash.indexOf("tags") > 0) {
            ajaxTags();
            return;
        }

        if (hash.indexOf("guestbook") > 0) {
            var guestbook_page = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            ajaxGuestBook(-1, guestbook_page);
            return;
        }

        if (hash.indexOf("info") > 0) {
            ajaxUserInfo();
            return;
        }

        if (hash.indexOf("album_all") > 0) {
            ajaxAlbum();
            return;
        }

        if (hash.indexOf("album_page") > 0) {
            var album_page = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            ajaxAlbumPage(-1, album_page);
            return;
        }

        if (hash.indexOf("album_category") > 0) {
            var album_category = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            var album_category_page = hash.substring(hash.indexOf("[") + 1, hash.indexOf("]"));
            ajaxAlbumCategory(album_category, album_category_page);
            return;
        }

        if (hash.indexOf("photo_album") > 0) {
            var album_id = hash.substring(hash.indexOf("{") + 1, hash.indexOf("}"));
            ajaxPhoto(album_id);
            return;
        }
    }
}
// End Hash Address


// Initialize blog
function initBlog() {
    $(document).ready(function () {

        // hide("loginPanel");
        createXMLHttpRequest();

        isSupportOnHashChange = isNewVersionIE();

                // Permalink
                var articleId = getQueryString("");
                if (articleId) {
                    toArticle(articleId);
                }
                // End Permalink

        if (isSupportOnHashChange) {

            hash();

            window.onhashchange = function () {
                hash();
            }
         }

    });
}
// End Initialize blog


// Create Gallery
function initGallery() {

    $(document).ready(function () {

        // We only want these styles applied when javascript is enabled
        $('div.navigation').css({ 'width': '300px', 'float': 'left' });
        $('div.content').css('display', 'block');

        // Initially set opacity on thumbs and add
        // additional styling for hover effect on thumbs
        var onMouseOutOpacity = 0.67;
        $('#thumbs ul.thumbs li').opacityrollover({
            mouseOutOpacity: onMouseOutOpacity,
            mouseOverOpacity: 1.0,
            fadeSpeed: 'fast',
            exemptionSelector: '.selected'
        });

        // Initialize Advanced Galleriffic Gallery
        var gallery = $('#thumbs').galleriffic({
            delay: 2500,
            numThumbs: 15,
            preloadAhead: 10,
            enableTopPager: true,
            enableBottomPager: true,
            maxPagesToShow: 7,
            imageContainerSel: '#slideshow',
            controlsContainerSel: '#controls',
            captionContainerSel: '#caption',
            loadingContainerSel: '#loading',
            renderSSControls: true,
            renderNavControls: true,
            playLinkText: 'Play Slideshow',
            pauseLinkText: 'Pause Slideshow',
            prevLinkText: '&lsaquo; Previous Photo',
            nextLinkText: 'Next Photo &rsaquo;',
            nextPageLinkText: 'Next &rsaquo;',
            prevPageLinkText: '&lsaquo; Prev',
            enableHistory: false,
            autoStart: false,
            syncTransitions: true,
            defaultTransitionDuration: 900,
            onSlideChange: function (prevIndex, nextIndex) {
                // 'this' refers to the gallery, which is an extension of $('#thumbs')
                this.find('ul.thumbs').children()
				.eq(prevIndex).fadeTo('fast', onMouseOutOpacity).end()
				.eq(nextIndex).fadeTo('fast', 1.0);
            },
            onPageTransitionOut: function (callback) {
                this.fadeTo('fast', 0.0, callback);
            },
            onPageTransitionIn: function () {
                this.fadeTo('fast', 1.0);
            }
        });

    });
}
// End Create Gallery


// get the sort string
function getSort() {
    var str = "";
    var re = /^\d+$/;
    var os = document.body.getElementsByTagName("input");
    for (var i = 0; i < os.length; i++) {
        if (os[i].type == "hidden") {
            if (!re.test(os[i].value)) {
                continue;
            }
            if (str.length > 0) {
                str += ",";
            }
            str += os[i].value;
        }
    }
    document.getElementById("sidebarSort").value = str;
    var f = document.forms[0];
    f.action = "default.aspx";
    f.method = "post";
    f.submit();
}