//  editor.js latest modified by Layy 2014-03-16

function isURL(urlString) {
    regExp = /(http[s]?|ftp):\/\/[^\/\.]+?\..+\w$/i;
    if (urlString.match(regExp))return true;
    else return false;
}

// ֤
function showCode(obj, page, type) {
    var timenow = new Date().getTime();
    obj.src=page+"?type="+type+"&d="+timenow;
}

function insertEmote(strCode) {
    var txtarea = document.getElementById("message");
    strCode = ' ' + strCode + ' ';
    if (txtarea.createTextRange && txtarea.caretPos)
    {
        var caretPos = txtarea.caretPos;
        caretPos.text = caretPos.text.charAt(caretPos.text.length - 1) == ' ' ? strCode + ' ' : strCode;
        txtarea.focus();
    }
    else
    {
        txtarea.value  += strCode;
        txtarea.focus();
    }
}

//Ctrl+Enter to Post
function CtrlEnter() { 
    if(event.ctrlKey && window.event.keyCode==13) document.commentForm.btnSubmit.click();
}

//Check Form
function checkForm(cid) {
    var errMessage, bError, theForm;
    var isUBB, isAutoUrl, isSmilies;
    errMessage="Some Required Field has not filled.";
    bError=false;
    if(document.getElementById("username").value=="") {
	    errMessage+="\n - Please input the username";
	    bError=true;
    }

	var url = document.getElementById("blogurl").value.trim();

    if(url.indexOf("http://") == -1) {
        url="http://"+url;
    }        
    if(!isURL(url)&&url.trim()!="http://") {
	    errMessage+="\n - Please input the right url";
	    bError=true;
    }
    if(document.getElementById("vcode").value=="") {
	    errMessage+="\n - Please input the validate code";
	    bError=true;
    }
    if(document.getElementById("vcode").value.len()<4) {
	    errMessage+="\n - It is not enough to input figure number of characters";
	    bError=true;
    }
    if(document.getElementById("message").value=="") {
	    errMessage+="\n - Please input the content";
	    bError=true;
    }
    
    if(bError) {
	    alert(errMessage);
	    return false;
    }
    else {
        scroll(0,0);
	    postComment(cid);
	    return true;
    }
}

// Quote Comment Text
function doQuote(id) {
    var obj=document.getElementById(id);
    var text=obj.innerHTML.trim();  
    text=text.replace(/alt\=(\"|)([^\"\s]*)(\"|)/g,"> $2 <");
    text=text.replace(/\<[^\<\>]+\>/g,"\n");
    text=text.replace(/ +/g," ");
    text=text.replace(/\n+/g,"\n");
    text=text.replace(/^\n*/gm,"");
    text=text.replace(/^\s*/gm,"");
    text=text.replace(/\n*$/gm,"");
    text=text.replace(/\s*$/gm,"");  
	document.getElementById("message").value += "[quote]\n"+text+"\n[/quote]\n";
}

function resetForm() {
    document.getElementById("username").value="";
    document.getElementById("blogurl").value="";
    document.getElementById("vcode").value="";
    document.getElementById("message").value="";
}