﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="access_log.aspx.cs" Inherits="MxBlog.manager.access_log" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>MxBlog Manager ---- Access Log</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link rel="stylesheet" type="text/css" href="styles/styles.css" />
    <script type="text/javascript" src="js/index.js" ></script>
    <script type="text/javascript" src="../js/common.js" ></script>
</head>
<body>
    <form id="formDeleteComment" runat="server">
    <div id="wrapper"><!-- wrapper -->
    
        <!-- top table -->
        <table id="toptable">
            <tr>
                <asp:Literal id="ltMenu" runat="server" Text="Layy"/>            
            </tr>
        </table>
        
        <!-- sidebar -->
        <table id="sidebar">
            <tr >
                <td id="sidebarWrapper" class="sidebarWrapper">
                    <asp:Literal id="ltSidebar" runat="server" Text="Layy"/>
                </td>
                <td class="mainWrapper">
                    <!-- list top -->
                    <table id="listTop">
                      <tr>
                        <td class="topheader">
                            <span>
                                <img id="down" class="btn" alt="toggle" onclick="togglePagebar(down)" src="images/hide_sidebar.png" />
                            </span>
                        </td>
                        <td class="topheader"></td>
                        <td class="topheader"></td>
                      </tr>
                    </table>
                    
                    <asp:GridView ID="GridView" runat="server" Width="100%" CellPadding="4" DataKeyNames="id"
                        AutoGenerateColumns="False" AllowPaging="True" PageSize="20"  AllowSorting="True"
                        OnPageIndexChanging="GridView_PageIndexChanging" CssClass="toptable" GridLines="None"
                        OnSorting="GridView_Sorting"
                        OnRowCreated="GridView_RowCreated">
                        <Columns>
                            <asp:BoundField DataField="id" ReadOnly="True" HeaderText="NO." SortExpression="id" HeaderStyle-CssClass="topheader" ItemStyle-CssClass="toptd" HeaderStyle-Width="10%" ItemStyle-Width="10%" ItemStyle-HorizontalAlign="Center" />
                            <asp:BoundField DataField="userAgent" ReadOnly="True" HeaderText="Client" SortExpression="userAgent" HeaderStyle-Width="30%" ItemStyle-Width="30%" />
                            <asp:BoundField DataField="ip" ReadOnly="True" HeaderText="IP" SortExpression="ip" HeaderStyle-Width="10%" ItemStyle-Width="10%" ItemStyle-HorizontalAlign="Center" />
                            <asp:BoundField DataField="url" ReadOnly="True" HeaderText="From" SortExpression="url" HeaderStyle-Width="30%" ItemStyle-Width="30%" />
                            <asp:BoundField DataField="language" ReadOnly="True" HeaderText="Language" SortExpression="language" HeaderStyle-Width="10%" ItemStyle-Width="10%" ItemStyle-HorizontalAlign="Center" />
                            <asp:BoundField DataField="date" ReadOnly="True" HeaderText="Date Time" SortExpression="date" HeaderStyle-Width="10%" ItemStyle-Width="10%" ItemStyle-HorizontalAlign="Center" />
                        </Columns>
                    </asp:GridView>

                    <p>
                        &nbsp;<asp:CheckBox ID="chkIsLog" runat="server" OnCheckedChanged="CheckBox_Changing" AutoPostBack="true" Text="Close Access Log" />
                    </p>

                    <p id="footer"><!-- copyright -->
                        <asp:Literal id="ltCopyRight" runat="server" Text="Layy"/>
                    </p>
                </td>
            </tr>
        </table>
        
    </div><!-- End wrapper-->
    </form>
</body>
</html>
