﻿/* MxBlog album.js latest modified by Layy 2014-04-09 Corresponding to the main navigation of the Album */

function addAlbum(action) {
    var errMessage = "Some required field has not filled.";
    bError = false;

    var title = document.getElementById("txTitle").value.trim();
    var txCategory = document.getElementById("txAlbumCategory").value.trim();
    var category = document.getElementById("category_tree").value.trim();

    if (title == "") {
        errMessage += "\n - Please input the title";
        bError = true;
    }
    if (title.length > 16) {
        errMessage += "\n - The title is too long";
        bError = true;
    }
    if (category == 0 && txCategory == "") {
        errMessage += "\n - Please select a category or input one";
        bError = true;
    }
    if (bError) {
        alert(errMessage);
        return false;
    }

    doSubmit("index.aspx?sidebar=common_info&main=add_album&action=" + action);
}

function addAlbumCategory() {
    var errMessage = "Some required field has not filled.";
    bError = false;

    var category = document.getElementById("txAlbumCategory").value.trim();

    if (category == "") {
        errMessage += "\n - Please input the album category";
        bError = true;
    }

    if (bError) {
        alert(errMessage);
        return false;
    }

    doSubmit("index.aspx?sidebar=common_info&main=add_album_category&action=do_add_album_category");
}

function deleteAlbumCategory(id) {
    doSubmit("index.aspx?sidebar=common_info&main=album_category_settings&action=do_delete_album_category&album_category_id=" + id);
}

function updateAlbumCategory() {
    doSubmit("index.aspx?sidebar=common_info&main=album_category_settings&action=do_update_album_category_settings");
}

function submitAlbum(id) {
    redirect("index.aspx?sidebar=common_info&main=upload_photo&album_id=" + id);
}

function showAlbumText() {
    reversal('categorytexttr');
    reversal('categoryselecttr');
}