﻿/* MxBlog system.js latest modified by Layy 2014-03-19 Corresponding to the main navigation of the System */

function isURL(urlString) {
    regExp = /(http[s]?|ftp):\/\/[^\/\.]+?\..+\w$/i;
    if (urlString.match(regExp)) return true;
    else return false;
}

function changePassword() {
    var errMessage = "Some required field has not filled.";
    bError = false;

    var pwd = document.getElementById("txPwd").value.trim();
    var newPwd = document.getElementById("txNewPwd").value.trim();
    var confirm = document.getElementById("txConfirm").value.trim();

    if (pwd == "") {
        errMessage += "\n - Please input your old password";
        bError = true;
    }

    if (newPwd == "") {
        errMessage += "\n - Please input your new password";
        bError = true;
    }

    if (newPwd == "") {
        errMessage += "\n - Please confirm the new password";
        bError = true;
    }

    if (bError) {
        alert(errMessage);
        return false;
    }
    
    doSubmit("index.aspx?sidebar=system&main=change_password&action=do_change_password");
}

function updateLink() {
    doSubmit("index.aspx?sidebar=system&main=link_settings&action=do_update_links");
}

function deleteLink(id) {
    doSubmit("index.aspx?sidebar=system&main=link_settings&action=do_delete_link&link_id=" + id);
}

function addLink(id)
{
    var errMessage = "Some required field has not filled.";
    bError = false;

    var title = document.getElementById("txLink").value.trim();
    var url = document.getElementById("txUrl").value.trim();
    var imgUrl = document.getElementById("txImgUrl").value.trim();

    if (title == "") {
        errMessage += "\n - Please input the title";
        bError = true;
    }

    if (url == "") {
        errMessage += "\n - Please input the url";
        bError = true;
    }else if (!isURL(url) && url.trim() != "http://") {
        errMessage += "\n - Please input the right url";
        bError = true;
    }

    if (bError) {
        alert(errMessage);
        return false;
    }

    if (bError) {
        alert(errMessage);
        return false;
    }

    doSubmit("index.aspx?sidebar=system&main=link_settings&action=do_add_link");
}

function backupDatabase() {
    doSubmit("index.aspx?sidebar=system&main=database&action=do_backup");
}

function restoreDatabase() {
    doSubmit("index.aspx?sidebar=system&main=database&action=do_restore");
}