﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="default.aspx.cs" Inherits="MxBlog._default" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <title><%=user.BlogTitle%> ---- <%=user.BlogDesc%></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="description" content="<%=user.BlogTitle%> ---- <%=user.BlogDesc%>" />
    <link rel="stylesheet" type="text/css" href="skin/<%=style%>/styles.css" />
    <script type="text/javascript" src="js/common.js" ></script>
    <script type="text/javascript" src="js/ajax.js" ></script>
    <script type="text/javascript" src="js/editor.js" ></script>
    <script type="text/javascript" src="js/jquery-1.3.2.min.js" ></script>
    <asp:Literal id="ltHead" runat="server" Text=""/>
</head>
<body>
    <div id="wrapper"><!-- wrapper -->
        <div id="innerWrapper"><!-- innerWrapper -->

            <div id="header"><!-- header -->
                <div id="innerHeader"><!-- innerHeader -->
                    <div id="blogLogo"></div>
                    <div id="blogTop"><!-- blogTop -->
                        <h1 id="blogTitle"><%=user.BlogTitle%></h1>
                        <div id="blogDesc"><%=user.BlogDesc%></div>
                    </div><!-- End blogTop -->
                    <div class="menu"><!-- menu -->
                        <div id="menuLeft"></div>
                        <div id="menuRight"></div>
                        <ul>
                            <li><a href="javascript:toPage(-1, '1')"><%=lang["TitleForHome"].ToString()%></a></li>
                            <li><a href="javascript:getAlbum()"><%=lang["TitleForAlbum"].ToString()%></a></li>
                            <li><a href="javascript:getTags()"><%=lang["TitleForTags"].ToString()%></a></li>
                            <li><a href="javascript:toGuestBook(-1, '1')"><%=lang["TitleForGuestBook"].ToString()%></a></li>
                            <li><a href="javascript:getUserInfo()"><%=lang["TitleForProfile"].ToString()%></a></li>
                            <li><a href="javascript:toggleSidebar()"><%=lang["TitleForToggleSidebar"].ToString()%></a></li>
                            <asp:Literal id="ltMenu" runat="server" Text=""/>
                            <li><a href="javascript:openLogin()"><%=lang["TitleForLogin"].ToString()%></a></li><!-- javascript:toggleLogin() -->
                        </ul>
                    </div><!-- End menu -->
                </div><!-- End innerHeader -->
            </div><!-- End header -->

            <div id="mainWrapper"><!-- mainWrapper -->
                <div id="main"><!-- main -->

                    <div id="content"><!-- content -->
                        <div id="tip" style="display:none"><img id="loadingImage" alt="" src="skin/<%=style%>/images/loading.gif"/> Processing Data , Please wait...</div>
                        <div id="innerContent"><!-- innerContent -->
                            <asp:Literal id="ltContent" runat="server"></asp:Literal>
                        </div><!-- End innerContent -->
                    </div><!-- End content -->
                   
                    <form id="MxForm" runat="server"><!-- MxForm -->
                    <input type="hidden" id="sidebarSort" name="sidebarSort" value="" runat="server"/>
                    <asp:Calendar id="MxCalendar" CssClass="calendar" runat="server" CellPadding="2" CellSpacing="1" Width="180px" Height="157px" DayNameFormat="Full" SelectionMode="None" TitleStyle-BackColor="Transparent" NextPrevStyle-CssClass="nextPrev" DayHeaderStyle-CssClass="dayHeader" DayStyle-CssClass="day" OtherMonthDayStyle-CssClass="otherMonth" SelectedDayStyle-CssClass="selectedDay" SelectorStyle-CssClass="selector" TitleStyle-CssClass="titleDay" TodayDayStyle-CssClass="today" WeekendDayStyle-CssClass="weekend"></asp:Calendar>
                    <div id="sidebar"><!-- sidebar -->
                        <asp:Panel id="innerSidebar" runat="server"><!-- innerSidebar -->
                        </asp:Panel><!-- End innerSidebar -->
                    </div><!-- End sidebar -->
                    </form><!-- End MxForm -->
                    
                    <div class="clear"></div>
                    
                </div><!-- End main -->
            </div><!-- End mainWrapper -->

            <div id="footer"><!-- footer -->
                <div id="innerFooter"> 
                    <asp:Literal id="ltCopyRight" runat="server" Text="Layy" />
                    <br />
                    <span id="run" runat="server"></span>
                </div>
                <div id="support">
                    <a class="support" target="_blank" href="http://validator.w3.org"><img src="skin/<%=style%>/images/html5.png" alt="html5" /></a> 
                    <a class="support" target="_blank" href="http://validator.w3.org"><img src="skin/<%=style%>/images/css3.png" alt="css3" /></a> 
                    <a class="support" target="_blank" href="rss.aspx"><img src="skin/<%=style%>/images/rss.png" alt="rss" /></a>
                </div>
            </div><!-- End footer -->

        </div><!-- End innerWrapper -->
    </div><!-- End wrapper-->            	    
</body>
</html>