﻿// common.js latest modified by Layy 2014-04-12

//function $(id) {
//    return document.getElementById(id);    
//}

function printf(obj, html) {
    document.getElementById(obj).innerHTML = html;
}

function reveal(obj) {
    document.getElementById(obj).style.display = "";
}

function hide(obj) {
    document.getElementById(obj).style.display = "none";
}

function reversal(obj) {
    if (document.getElementById(obj).style.display == "none") {
        reveal(obj);
    }
    else {
        hide(obj);
    }
}

// Trim
function trim(str) {
    return str.replace(/(^[\s　]*)|([\s　]*$)/g, '');
}
String.prototype.trim = function () {
    return this.replace(/(^[\s　]*)|([\s　]*$)/g, '');
}

// Byte Counter
function len(str) {
    var bytes = 0;
    for (i = 0; i < str.length; i++) {
        ascii = str.charCodeAt(i);
        bytes += (ascii < 255 ? 1 : 2);
    }
    return bytes;
}
String.prototype.len = function () {
    var bytes = 0;
    for (i = 0; i < this.length; i++) {
        ascii = this.charCodeAt(i);
        bytes += (ascii < 255 ? 1 : 2);
    }
    return bytes;
}

// Set Article Font Size
function setFontSize(pt) {
    try {
        var t = document.getElementById("main");
        if (t) {
            t.style.fontSize = pt + "pt";
        }
    }
    catch (e) { }
}

function toggleSidebar() {
    try {
        var objSidebar = document.getElementById("sidebar");
        var objContent = document.getElementById("main");
        if (objSidebar.className != "sidebarHide") {
            objSidebar.className = "sidebarHide";
            objSidebar.style.display = "none";
            objContent.className = "contentWide";
        }
        else {
            objSidebar.className = "sidebar";
            objSidebar.style.display = "block";
            objContent.className = "main";
        }
    }
    catch (e) { }
}

function toggleLogin() {
    try {
        var panel = document.getElementById("loginPanel");
        if (panel) {
            if (panel.style.display == 'none') {
                panel.style.display = 'block';
            }
            else {
                panel.style.display = 'none';
            }
        }
    }
    catch (e) { }
}

function redirect(url) {
    window.location.replace(url);
}

function setNormal() {
    setCookie("ViewMode", "Normal");
    toPage(-1, '1');
    ajaxPage(-1, '1');
}

function setList() {
    setCookie("ViewMode", "List");
    toPage(-1, '1');
    ajaxPage(-1, '1');
}

function setAlbumNormal() {
    setCookie("AlbumMode", "Normal");
    toAlbumPage(-1, '1');
}

function setAlbumPage() {
    setCookie("AlbumMode", "Page");
    toAlbumPage(-1, '1');
}

function getQueryString(query) {
    var returnValue = "";
    var URLString = new String(document.location);
    var serachLocation = -1;
    var queryStringLength = query.length;
    do {
        serachLocation = URLString.indexOf(query + "\=");
        if (serachLocation != -1) {
            if ((URLString.charAt(serachLocation - 1) == '?') || (URLString.charAt(serachLocation - 1) == '&')) {
                URLString = URLString.substr(serachLocation);
                break;
            }
            URLString = URLString.substr(serachLocation + queryStringLength + 1);
        }
    }
    while (serachLocation != -1)
    if (serachLocation != -1) {
        var seperatorLocation = URLString.indexOf("&");
        if (seperatorLocation == -1) {
            returnValue = URLString.substr(queryStringLength + 1);
        }
        else {
            returnValue = URLString.substring(queryStringLength + 1, seperatorLocation);
        }
    }
    return returnValue;
}

function getCookieValue(offset) { // 获得Cookie解码后的值
    var endstr = document.cookie.indexOf(";", offset);
    if (endstr == -1)
        endstr = document.cookie.length;
    return unescape(document.cookie.substring(offset, endstr));
}

function setCookie(name, value) { // 设定Cookie值
    var expdate = new Date();
    var argv = setCookie.arguments;
    var argc = setCookie.arguments.length;
    var expires = (argc > 2) ? argv[2] : null;
    var path = (argc > 3) ? argv[3] : null;
    var domain = (argc > 4) ? argv[4] : null;
    var secure = (argc > 5) ? argv[5] : false;
    if (expires != null) expdate.setTime(expdate.getTime() + (expires * 1000));
    document.cookie = name + "=" + escape(value) + ((expires == null) ? "" : ("; expires=" + expdate.toGMTString()))
    + ((path == null) ? "" : ("; path=" + path)) + ((domain == null) ? "" : ("; domain=" + domain))
    + ((secure == true) ? "; secure" : "");
}

function delCookie(name) { // 删除Cookie
    var exp = new Date();
    exp.setTime(exp.getTime() - 1);
    var cval = getCookie(name);
    document.cookie = name + "=" + cval + "; expires=" + exp.toGMTString();
}

function getCookie(name) // 获得Cookie的原始值
{
    var arg = name + "=";
    var alen = arg.length;
    var clen = document.cookie.length;
    var i = 0;
    while (i < clen) {
        var j = i + alen;
        if (document.cookie.substring(i, j) == arg)
            return getCookieValue(j);
        i = document.cookie.indexOf(" ", i) + 1;
        if (i == 0) break;
    }
    return null;
}

function doSubmit(act) {
    try {
        if (confirm("Submit?")) {
            var f = document.forms[0];
            f.action = act;
            f.method = "post";
            f.submit();
        }

    }
    catch (e) { }
}

function doClick(id) {
    document.getElementById(id).click();
}

// split article
String.prototype.replaceAll = function (s1, s2) {
    return this.replace(new RegExp(s1, "gm"), s2);
}
String.prototype.len = function () {
    var str = this;
    return str.replace(/[^\x00-\xff]/g, "**").length
}

function DrawImage(ImgD, FitWidth, FitHeight) {

    var ua = navigator.userAgent.toLowerCase();
    if (window.ActiveXObject)
        IE = ua.match(/msie ([\d.]+)/)[1];
    if (IE == "6.0") {

        var image = new Image();
        image.src = ImgD.src;
        if (image.width > 0 && image.height > 0) {
            if (image.width / image.height >= FitWidth / FitHeight) {
                if (image.width > FitWidth) {
                    ImgD.width = FitWidth;
                    ImgD.height = (image.height * FitWidth) / image.width;
                }
                else {
                    ImgD.width = image.width;
                    ImgD.height = image.height;
                }
            }
            else {
                if (image.height > FitHeight) {
                    ImgD.height = FitHeight;
                    ImgD.width = (image.width * FitHeight) / image.height;
                }
                else {
                    ImgD.width = image.width;
                    ImgD.height = image.height;
                }
            }
        }
    }

}