﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="edit_article.aspx.cs" Inherits="MxBlog.manager.edit_article" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>MxBlog Manager ---- Edit Article</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link rel="stylesheet" type="text/css" href="styles/styles.css" />
    <script type="text/javascript" src="js/index.js" ></script>
    <script type="text/javascript" src="../js/common.js" ></script>
    <script type="text/javascript" src="js/article.js" ></script>
</head>
<body>
    <form id="formEditArticle" runat="server">
    
    <div id="wrapper"><!-- wrapper -->
    
        <!-- top table -->
        <table id="toptable">
            <tr>
                <asp:Literal id="ltMenu" runat="server" Text="Layy"/>
            </tr>
        </table>
        
        <!-- sidebar -->
        <table id="sidebar">
            <tr style="vertical-align:top;">
                <td id="sidebarWrapper" class="sidebarWrapper">
                    <asp:Literal id="ltSidebar" runat="server" Text="Layy"/>
                </td>

                <td class="mainWrapper">
                    <!-- list top -->
                    <table class="toptable" id="listTop">
                      <tr>
                        <td class="topheader"><span style="width:16px;height:16px;background-color:transparent;"><img id="down" alt="toggle" class="btn" onclick="togglePagebar(down)" src="images/hide_sidebar.png" /></span></td>
                        <td style="height:64px;font-weight:bold;text-align:left;">
                            <span style="width:16px;height:16px;background-color:transparent;margin-left:7px;">
                            <input type="text" class="text title" name="txSearch" id="txSearch" value="" runat="server" />
                            <asp:ImageButton ID="imgSearch" runat="server" ImageUrl="images/btn_search.gif" OnClick="imgSearch_Click" ImageAlign="AbsMiddle" Height="24px" Width="100px" ></asp:ImageButton>
                            </span>
                        </td>
                        <td class="topheader">
                            <asp:DropDownList ID="ddlCategory" AutoPostBack="true" DataTextField="title" DataValueField="id" runat="server" OnSelectedIndexChanged="ddlCategory_SelectedIndexChanged">
                            </asp:DropDownList>
                        </td>
                      </tr>
                    </table>
                    
                    <asp:GridView ID="EditGridView" runat="server" Width="100%" CellPadding="4" DataKeyNames="id,title"
                        AutoGenerateColumns="False" AllowPaging="True" PageSize="22" AllowSorting="True" PagerStyle-CssClass="toptd"
                        OnPageIndexChanging="EditGridView_PageIndexChanging" CssClass="toptable" GridLines="None"
                        OnSorting="EditGridView_Sorting" OnRowDeleting="EditGridView_RowDeleting" 
                        EnableViewState="true" OnRowCreated="EditGridView_RowCreated">
                        <Columns>
                            <asp:BoundField DataField="id" ReadOnly="True" HeaderText="NO." SortExpression="id" HeaderStyle-CssClass="topheader" ItemStyle-CssClass="toptd" HeaderStyle-Width="5%" ItemStyle-Width="5%" ItemStyle-HorizontalAlign="Center" />
                            <asp:TemplateField HeaderText="Title" SortExpression="title" HeaderStyle-Width="40%" ItemStyle-Width="40%">
                                <ItemTemplate>
							        <%#show(DataBinder.Eval(Container.DataItem, "id"), DataBinder.Eval(Container.DataItem, "title"))%>
						        </ItemTemplate>             
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Category" SortExpression="categoryId" HeaderStyle-Width="20%" ItemStyle-Width="20%">
                                <ItemTemplate>
							        <%#getCategory(DataBinder.Eval(Container.DataItem, "categoryId"))%>
						        </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="date" ReadOnly="True" HeaderText="Date Time" SortExpression="date" HeaderStyle-Width="15%" ItemStyle-Width="15%" ItemStyle-HorizontalAlign="Center" />
                            <asp:BoundField DataField="views" ReadOnly="True" HeaderText="Views" SortExpression="views" HeaderStyle-Width="5%" ItemStyle-Width="5%" ItemStyle-HorizontalAlign="Center" />
                            <asp:ButtonField Text="<img alt='' src='images/btn_delete.gif' border='0' />" HeaderText="Delete" CommandName="Delete" HeaderStyle-Width="5%" ItemStyle-Width="5%" ItemStyle-HorizontalAlign="Center" />
                        </Columns>
                    </asp:GridView>
                    
                    <p id="footer"><!-- copyright -->
                        <asp:Literal id="ltCopyRight" runat="server" Text="Layy"/>
                    </p>
                </td>
            </tr>
        </table>
        
    </div><!-- End wrapper-->
    
    </form>
</body>
</html>