﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="edit_photo.aspx.cs" Inherits="MxBlog.manager.edit_photo" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>MxBlog Manager ---- Edit Photo</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link rel="stylesheet" type="text/css" href="styles/styles.css" />
    <script type="text/javascript" src="js/index.js" ></script>
    <script type="text/javascript" src="../js/common.js" ></script>
</head>
<body>
    <form id="formEditPhoto" runat="server">
    
    <div id="wrapper"><!-- wrapper -->
    
        <!-- top menu -->
        <table id="toptable">
            <tr>
                <asp:Literal id="ltMenu" runat="server" Text="Layy"/>
            </tr>
        </table>
        
        <!-- sidebar -->
        <table id="sidebar">
            <tr style="vertical-align:top;">
                <td id="sidebarWrapper" class="sidebarWrapper" valign="top">
                    <asp:Literal id="ltSidebar" runat="server" Text="Layy"/>
                </td>

                <td class="mainWrapper">
                    <!-- list top -->
                    <table class="toptable" id="listTop">
                      <tr>
                        <td class="topheader">
                            <span style="width:16px;height:16px;background-color:transparent;">
                            <img id="down" alt="toggle" class="btn" onclick="togglePagebar(down)" src="images/hide_sidebar.png" />
                            </span>  <%=result%>
                        </td>
                        <td style="height:64px;font-weight:bold;text-align:left;">
                            <span style="width:16px;height:16px;background-color:transparent;margin-left:7px;">
                            <input type="text" class="text title" name="txSearch" id="txSearch" value="" runat="server" />
                            <asp:ImageButton ID="imgSearch" runat="server" ImageUrl="images/btn_search.gif" OnClick="imgSearch_Click" ImageAlign="AbsMiddle" Height="24px" Width="100px" ></asp:ImageButton>
                            </span>
                        </td>
                        <td class="topheader">
                            <asp:DropDownList ID="ddlCategory" AutoPostBack="true" DataTextField="title" DataValueField="id" runat="server" OnSelectedIndexChanged="ddlCategory_SelectedIndexChanged">
                            </asp:DropDownList>
                        </td>
                      </tr>
                    </table>
                    
                    <!-- list main -->
                    <asp:GridView ID="EditGridView" runat="server" DataKeyNames="id,title"
                        Width="100%" CellPadding="4" GridLines="None"
                        CssClass="toptable" PagerStyle-CssClass="toptd"                      
                        EnableViewState="true"
                        AutoGenerateColumns="False"
                        AllowPaging="True" PageSize="22"
                        AllowSorting="True"
                        OnPageIndexChanging="EditGridView_PageIndexChanging"
                        OnSorting="EditGridView_Sorting"
                        OnRowDeleting="EditGridView_RowDeleting"
                        OnRowUpdating="EditGridView_RowUpdating"
                        OnRowCancelingEdit="EditGridView_RowCancelingEdit"
                        OnRowEditing="EditGridView_RowEditing"
                        OnRowCreated="EditGridView_RowCreated" 
                        OnRowCommand="EditGridView_RowCommand">
                        <Columns>
                            <asp:BoundField DataField="id" ReadOnly="True" HeaderText="NO." SortExpression="id" HeaderStyle-CssClass="topheader" ItemStyle-CssClass="toptd" HeaderStyle-Width="5%" ItemStyle-Width="5%" ItemStyle-HorizontalAlign="Center" />
                            <asp:TemplateField HeaderText="Photo" SortExpression="thumb" HeaderStyle-Width="10%" ItemStyle-Width="10%" ItemStyle-HorizontalAlign="Center">
                                <ItemTemplate>
                                    <asp:ImageButton ID="btnSet" Width="75" Height="75" runat="server" CommandName="SetUrlToClipboard" CommandArgument='<%#DataBinder.Eval(Container.DataItem, "url")%>' ImageUrl='<%#DataBinder.Eval(Container.DataItem, "thumb")%>' />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="title" HeaderText="Title" SortExpression="title" HeaderStyle-Width="15%" ItemStyle-Width="15%" ItemStyle-HorizontalAlign="Center" />
                            <asp:TemplateField HeaderText="Set cover" SortExpression="albumId" HeaderStyle-Width="10%" ItemStyle-Width="10%">
                                <ItemTemplate>
                                    <asp:LinkButton ID="btnCover" runat="server" CommandName="SetAsCover" CommandArgument='<%#DataBinder.Eval(Container.DataItem, "id")%>' Text='<%#getAlbum(DataBinder.Eval(Container.DataItem, "albumId"))%>' />
                                </ItemTemplate>
                            </asp:TemplateField>                            
                            <asp:BoundField DataField="description" HeaderText="Description" SortExpression="description" HeaderStyle-Width="15%" ItemStyle-Width="15%" ItemStyle-HorizontalAlign="Center" />
                            <asp:BoundField DataField="sort" HeaderText="Sort" SortExpression="sort" HeaderStyle-Width="5%" ItemStyle-Width="5%" ItemStyle-HorizontalAlign="Center" />
                            <asp:TemplateField HeaderText="Url" SortExpression="url" HeaderStyle-Width="20%" ItemStyle-Width="20%">
                                <ItemTemplate>
                                    <%#DataBinder.Eval(Container.DataItem, "url")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="date" ReadOnly="True" HeaderText="Date Time" SortExpression="date" HeaderStyle-Width="10%" ItemStyle-Width="10%" ItemStyle-HorizontalAlign="Center" />
                            <asp:ButtonField Text="<img alt='delete' src='images/btn_delete.gif' border='0' />" HeaderText="Delete" CommandName="Delete" HeaderStyle-Width="5%" ItemStyle-Width="5%" ItemStyle-HorizontalAlign="Center" />
                            <asp:CommandField HeaderText='Edit' EditText='Edit' CancelText='Cancel' UpdateText='Update' ShowHeader='true' ShowEditButton='true' HeaderStyle-Width="5%" ItemStyle-Width="5%" ItemStyle-HorizontalAlign="Center" />
                        </Columns>
                    </asp:GridView>
                    
                    <p id="footer">
                        <!-- copyright -->
                        <asp:Literal id="ltCopyRight" runat="server" Text="Layy"/>
                    </p>
                </td>
            </tr>
        </table>
        
    </div><!-- End wrapper-->
    
    </form>
</body>
</html>