﻿/* MxBlog article.js latest modified by Layy 2014-03-19 Corresponding to the main navigation of the Article */

function addArticle(action) {
    var errMessage = "Some required field has not filled.";
    bError = false;

    var title = document.getElementById("txTitle").value.trim();
    var category = document.getElementById("category_tree").value.trim();
    var author = document.getElementById("txAuthor").value.trim();

    if (title == "") {
        errMessage += "\n - Please input the title";
        bError = true;
    }
    if (category == 0) {
        errMessage += "\n - Please select a category";
        bError = true;
    }
    if (author == "") {
        errMessage += "\n - Please input the author";
        bError = true;
    }
    if (bError) {
        alert(errMessage);
        return false;
    }

    doSubmit("index.aspx?sidebar=article&main=add_article&action=" + action);
}

function updateArticleSettings() {
    var errMessage = "Some required field has not filled.";
    bError = false;

    var normalPage = document.getElementById("txNormalPerPage").value.trim();
    var listPage = document.getElementById("txListPerPage").value.trim();
    var recentArticles = document.getElementById("txRecentArticles").value.trim();
    var autoSplit = document.getElementById("txAutoSplit").value.trim();

    if (normalPage == "") {
        errMessage += "\n - Please input the normal per page";
        bError = true;
    }
    if (listPage == 0) {
        errMessage += "\n - Please input the list per page";
        bError = true;
    }
    if (recentArticles == "") {
        errMessage += "\n - Please input the recent articles";
        bError = true;
    }
    if (autoSplit == "") {
        errMessage += "\n - Please input the auto split";
        bError = true;
    }

    if (bError) {
        alert(errMessage);
        return false;
    }

    doSubmit("index.aspx?sidebar=article&main=article_settings&action=do_update_article_settings");
}

function editArticle(id) {
    var url = "edit_article.aspx?action=edit&id=" + id;
    redirect(url);
}

function deleteArticle(id) {
    doSubmit("delete_article.aspx?action=delete&article_id=" + id);
}

function addCategory() {
    var errMessage = "Some required field has not filled.";
    bError = false;

    var category = document.getElementById("txCategory").value.trim();

    if (category == "") {
        errMessage += "\n - Please input the category";
        bError = true;
    }

    if (bError) {
        alert(errMessage);
        return false;
    }

    doSubmit("index.aspx?sidebar=article&main=article_settings&action=do_add_category");
}

function deleteCategory(id) {
    doSubmit("index.aspx?sidebar=article&main=category_settings&action=do_delete_category&category_id=" + id);
}

function updateCategory() {
    doSubmit("index.aspx?sidebar=article&main=category_settings&action=do_update_category_settings");
}

function updateAnnounce() {
    doSubmit("index.aspx?sidebar=article&main=announce&action=do_update_announce");
}

function updateGlobal() {
    doSubmit("index.aspx?sidebar=system&main=global_settings&action=do_update_global_settings");
}

function deleteTag(id) {
    doSubmit("index.aspx?sidebar=system&main=tag&action=do_delete_tag&tag_id=" + id);
}