﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="upload.aspx.cs" Inherits="MxBlog.manager.plupload.upload" %>
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
<link rel="stylesheet" href="css/plupload.queue.css" type="text/css" media="screen" />
<title>Upload Photo</title>
<script type="text/javascript" src="../../js/common.js"></script>
<script type="text/javascript" src="../../js/jquery-1.3.2.min.js"></script>
<script type="text/javascript" src="jquery.plupload.queue.min.js"></script>
<script type="text/javascript" src="plupload.min.js"></script>
<script type="text/javascript" src="plupload.flash.min.js"></script>
<script type="text/javascript">
    $(function () {
        $.urlParam = function (query) {
            var returnValue = "";
            var URLString = new String(document.location);
            var serachLocation = -1;
            var queryStringLength = query.length;
            do {
                serachLocation = URLString.indexOf(query + "\=");
                if (serachLocation != -1) {
                    if ((URLString.charAt(serachLocation - 1) == '?') || (URLString.charAt(serachLocation - 1) == '&')) {
                        URLString = URLString.substr(serachLocation);
                        break;
                    }
                    URLString = URLString.substr(serachLocation + queryStringLength + 1);
                }
            }
            while (serachLocation != -1)
            if (serachLocation != -1) {
                var seperatorLocation = URLString.indexOf("&");
                if (seperatorLocation == -1) {
                    returnValue = URLString.substr(queryStringLength + 1);
                }
                else {
                    returnValue = URLString.substring(queryStringLength + 1, seperatorLocation);
                }
            }
            return returnValue;
        }

        var album_id = $.urlParam('album_id');
        var url = 'process_upload.aspx?album_id=' + album_id;

        // 初始化Flash上传插件
        $("#flash_uploader").pluploadQueue({
            runtimes: 'flash', 	//使用Flash插件
            url: url, 	//服务器端响应页面
            max_file_size: '10mb', //最大文件限制
            chunk_size: '1mb', 	//一次上传数据大小
            unique_names: true, 	//是否自动生成唯一名称
            filters: [				//文件类型限制
				{title: "图片文件", extensions: "jpg,gif,png" },
				{title: "压缩文件", extensions: "zip,rar" }
			],

            // 缩放图片
            //resize: { width: 500, height: 500, quality: 1000 },

            // SWF文件位置
            flash_swf_url: 'plupload.flash.swf',

            init: {
                FileUploaded: function (up, file, info) {
                    //一个文件上传成功
                    //alert(info.response);
                },

                Error: function (up, args) {
                    //发生错误
                    if (args.file) {
                        alert('[error] File:' + args.file);
                    } else {
                        alert('[error]' + args);
                    }
                }
            }
        });
    });
</script>

</head>
<body>
	<div>
		<div id="flash_uploader" style="width: 600px; height: 600px;">You do not have Flash plug-in!</div>
	</div>
</body>
</html>
