﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using wuxiu.QMVC.APPS.App;

namespace wuxiu.QMVC.APPS
{
    public static class APPManager
    {
        static bool initedBAZ = false;
        public static string DefaultAPP = "Default";
        public const string DEFAULT_CONTROLLER = "Home";
        public const string DEFAULT_ACTION = "Index";
        /*public static void Init(string root_path)
        {
            Init(root_path, Assembly.GetCallingAssembly());
        }*/
        public static string wuxiuRootPath;
        public static void InitAllApps(string root_path,string DefaultAPP)
        {
            APPManager.DefaultAPP = DefaultAPP;
            wuxiuRootPath = root_path;
            if (initedBAZ) throw new Exception("APPManager is inited.");
            initedBAZ = true;
            //init Apps
            Router.UrlRouter router = new Router.UrlRouter();
            wuxiu.QMVC.Router.RouterManager.SetRouter(router);

            //Register wuxiu Default router
            /*wuxiuMainAppProvider wuxiuprovider=new wuxiuMainAppProvider();
            wuxiuprovider.InitApp(web_assembly);
            router.rules.Add(new Router.RouterItemInfo(wuxiu_URL_START, wuxiuprovider));*/

            //cache apps and add routers
            foreach (string app_dir in Directory.GetDirectories(root_path + "\\APPS"))
            {
                App.AppLoadInfo configinfo = new App.AppLoadInfo();
                configinfo.LoadConfig(app_dir.Substring(app_dir.LastIndexOf("\\")+1));
                if (configinfo.Enable)
                {
                    //Load DLL
                    Assembly asm;
                    if (configinfo.Assembly.StartsWith("bin:"))
                    {
                        asm = Assembly.Load(configinfo.Assembly.Substring("bin:".Length));
                    }
                    else if (configinfo.Assembly.StartsWith("file:"))
                    {
                        asm = Assembly.LoadFrom(app_dir + "\\Bin\\" + configinfo.Assembly.Substring("file:".Length));
                    }
                    else
                    {
                        throw new Exception("the App config.xml Error,Xml element “assembly” is wrong.App name:" + configinfo.Name + ",asembly=" + configinfo.Assembly);
                    }
                    Type t = asm.GetType(configinfo.AppProviderClass);

                    //LoadAppProvider
                    AppProvider provider = Activator.CreateInstance(t) as AppProvider;
                    provider.InitApp(configinfo);
                    if (provider != null)
                    {
                        router.rules.Add(new Router.RouterItemInfo( configinfo.appID + "/", provider));
                    }
                    else
                    {
                        throw new Exception("未能将类对象" + t.FullName + "转换为" + typeof(AppProvider).FullName);
                    }


                }
            }

        }


    }
}
