﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Xml;
using System.Xml.Linq;

namespace wuxiu.QMVC.APPS.App
{
    public class AppLoadInfo
    {

        public string Name { get; set; }
        public string Version { get; set; }
        public string Copyright { get; set; }
        public string AppProviderClass { get; set; }
        public string Assembly { get; set; }
        public bool Enable { get; set; }
        public NameValueCollection appSettings { get; set; }
        public string appID { get; set; }
        public XElement configXml;

        public void LoadConfig(string appID)
        {
            string configfpath = APPManager.wuxiuRootPath + "\\Apps\\" + appID + "\\app.config";
            configXml = XElement.Load(configfpath);
            //xml = xml.Element("app");
            Name = configXml.Attribute("name").Value;
            Version = configXml.Attribute("version").Value;
            Copyright = configXml.Attribute("copyright").Value;
            AppProviderClass = configXml.Attribute("appProviderClass").Value;
            Assembly = configXml.Attribute("assembly").Value;
            Enable = bool.Parse(configXml.Attribute("enable").Value);
            this.appID = appID;
            appSettings = new NameValueCollection();
            XElement xml_appSettings = configXml.Element("appSettings");
            if (xml_appSettings != null)
            {
                foreach (XElement node in xml_appSettings.Elements("add"))
                {
                    appSettings.Add(node.Attribute("key").Value, node.Attribute("value").Value);
                }
            }
            //appSettings = info;
        }

    }
}
