﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Web;
using wuxiu.QMVC;
using wuxiu.QMVC.Router;

namespace wuxiu.QMVC.APPS
{
    public abstract class AppProvider
    {
        RouterControllerCollection app_controllers = new RouterControllerCollection();
        public virtual APPController RouteController(HttpContextBase context, string[] split_urls)
        {
            string controllerName, actionName;
            string[] url_params;
            if (split_urls.Length == 0)
            {
                controllerName = APPManager.DEFAULT_CONTROLLER;
                actionName = APPManager.DEFAULT_ACTION;
                url_params = new string[] { };
            }
            else if (split_urls.Length == 1)
            {
                controllerName = split_urls[0];
                actionName = APPManager.DEFAULT_ACTION;
                url_params = new string[] { };
            }
            else
            {
                controllerName = split_urls[0];
                actionName = split_urls[1];
                if (!actionName.EndsWith(".action"))
                {
                    return null;
                }
                actionName = actionName.Substring(0, actionName.Length - ".action".Length);
                url_params = new string[split_urls.Length - 2];
                if (url_params.Length > 0)
                {
                    for (int i = 0; i < url_params.Length;i++ )
                    {
                        url_params[i] = split_urls[i + 2];
                    }
                }
            }

            Type t = app_controllers.GetController(controllerName);

            if (t != null)
            {
                //RouterResult result = new RouterResult(true);
                //result.setResultData(t, url_params, action, controller);
                APPController controller = Activator.CreateInstance(t) as APPController;
                if (controller != null)
                {
                    controller.init(context, controllerName, actionName, url_params);
                    controller.appID = APPID;
                    return controller;
                }
            }
            return null;
        }
        public abstract void Init(App.AppLoadInfo appinfo);

        string _appID;
        public string APPID { get { return _appID; } }
        public virtual void InitApp(App.AppLoadInfo appinfo)
        {
            InitApp(appinfo,this.GetType().Assembly);
        }
        public virtual void InitApp(App.AppLoadInfo appinfo, Assembly assembly)
        {
            this._appID = appinfo.appID;
            app_controllers.LoadAssembly(assembly);
            Init(appinfo);
        }

        AppRouterCollection approuters = new AppRouterCollection();

        public void RegisterAssemblyControllers(Assembly assembly)
        {
            foreach (Type t in assembly.GetTypes())
            {
                if (t.IsPublic && t.IsSubclassOf(typeof(ControllerBase)) && !t.IsAbstract && t.Name.EndsWith("Controller"))
                {
                    try
                    {
                        approuters.Add(t.Name.ToLower(), t);
                    }
                    catch (Exception ex)
                    {
                        throw new Exception("在注册controller时，发现重名无法没册：" + t.FullName, ex);
                    }
                }
            }


        }


        void DefaultControllerRoute()
        {
            
        }

    }
}
