﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace wuxiu.QMVC.APPS
{
    public class AppRouter
    {
        public Type ControllerType;
        public string LowerControllerName;

    }


    public class AppRouterCollection : List<AppRouter>
    {
        public AppRouter Add(string ControllerName, Type type)
        {
            AppRouter router = new AppRouter();
            router.LowerControllerName = ControllerName;
            router.ControllerType = type;
            this.Add(router);
            return router;
        }
        public AppRouter this[string ControllerName]
        {
            get
            {
                string lower_cname=ControllerName.ToLower();
                foreach (AppRouter router in this)
                {
                    if (router.LowerControllerName.Equals(lower_cname))
                        return router;
                }
                return null;
            }
        }

    }


}
