﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using wuxiu.QMVC;

namespace wuxiu.QMVC.APPS.Router
{
    public class UrlRouter:wuxiu.QMVC.Router.IRouterProvider
    {
        public RouterItemCollection rules = new RouterItemCollection();

        public ControllerBase LoadUrl(HttpContextBase context, string sys_url)
        {
            if (string.IsNullOrEmpty(sys_url))
                sys_url = APPManager.DefaultAPP+"/";
            if (sys_url.IndexOf('?') != -1)
            {
                sys_url = sys_url.Substring(0, sys_url.IndexOf('?'));
            }
            RouterItemInfo info = rules.GetController(sys_url);
            if(info!=null)
            {
                string app_url = sys_url.Substring(info.LowerUrlStart.Length);
                if (app_url.EndsWith("/")) app_url = app_url.Substring(0, app_url.Length - 1);
                string[] split_urls = Utils.ClearStrArrayEmpty(app_url.Split('/'));
                return info.App.RouteController(context, split_urls);
            }
            return null;

        }
    }
}
