﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using System.Web.SessionState;

namespace wuxiu.QMVC
{
    public abstract class ControllerBase
    {
        string _controllerName;
        string _actionName;
        string[] _urlparams;

        public HttpContextBase Context { get; set; }
        public void init(HttpContextBase context, string controllerName, string actionName, string[] _urlparams)
        {
            this.Context = context;
            this._controllerName = controllerName;
            this._actionName = actionName;
            this._urlparams = _urlparams;
        }

        public HttpResponseBase Response { get { return Context.Response; } }
        public HttpRequestBase Request { get { return Context.Request; } }
        public HttpServerUtilityBase Server{ get { return Context.Server; } }
        public string[] UrlData { get { return _urlparams; } }
        public string ControllerName { get { return _controllerName; } }
        public string ActionName { get { return _actionName; } }
        public HttpSessionStateBase Session { get { return Context.Session; } }

        protected virtual string getTemplateUrl(string themeName,string controllerName,string viewName)
        {
            return "~/" + themeName + "Views/" + controllerName + "/" + viewName + ".cshtml";
        }

        public ViewResult View()
        {
            ViewResult result = new ViewResult(ActionName, "Default", ControllerName, getTemplateUrl);
            return result;
        }
        public virtual void InitRazor(MVCRzorPageBase razorPage)
        {

        }
        public void SaveView(ViewResult result, string saveto)
        {
            if (File.Exists(saveto))
            {
                throw new IOException(String.Format("File “{0}” was exists!",saveto));
            }
            using(StreamWriter writer=new StreamWriter(saveto,false,Context.Response.ContentEncoding))
            {
                wuxiu.QMVC.QMVCCore.PrintResultToStream(result, this, writer);
            }
        }
        public ViewResult ViewTemplate(string templateUrl)
        {
            templateurlhandler handler=new templateurlhandler();
            handler.templateurl=templateUrl;
            ViewResult result = new ViewResult(ActionName, "Default", ControllerName, new TemplateUrlHandler(handler.getTemplateUrl));
            return result;
        }
        class templateurlhandler
        {
            public string templateurl;
            public string getTemplateUrl(string themeName,string controllerName,string viewName)
            {
                return templateurl;
            }
        }
        public ViewResult View(object Model)
        {
            ViewResult result = new ViewResult(ActionName, "Default", ControllerName, getTemplateUrl);
            result.Model = Model;
            return result;
        }
        public ViewResult View(string ViewName)
        {
            ViewResult result = new ViewResult(ViewName, "Default", ControllerName, getTemplateUrl);
            return result;
        }
        public ViewResult View(string ViewName,object Model)
        {
            ViewResult result = new ViewResult(ViewName, "Default", ControllerName, getTemplateUrl);
            result.Model = Model;
            return result;
        }
        public ViewResult ViewTheme(string themeName)
        {
            ViewResult result = new ViewResult(ActionName, themeName, ControllerName, getTemplateUrl);
            return result;
        }

        public void WriteJSON(string json)
        {
            Response.ContentType = "application/json";
            Response.Write(json);
            Response.End();
        }
    }
}
