﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace wuxiu.QMVC
{
    public class DynamicDirectory:DynamicObject
    {
        Dictionary<string,object> dic=new Dictionary<string,object>();
        public override bool TryGetMember(GetMemberBinder binder, out object result)
        {
            if(!dic.TryGetValue(binder.Name.ToLower(), out result)){
                result = string.Empty;
            }
            return true;
        }
        public override bool TrySetMember(SetMemberBinder binder, object value)
        {
            string name = binder.Name.ToLower();
            if (dic.ContainsKey(name))
            {
                dic[name] = value;
            }
            else dic.Add(name, value);
            return true;
        }
    }
}
