﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.WebPages;
using System.Web.WebPages.Html;
using System.Web.WebPages.Scope;

namespace wuxiu.QMVC
{
    public abstract class MVCRzorPageBase : WebPageBase
    {
        private static readonly List<IWebPageRequestExecutor> _executors = new List<IWebPageRequestExecutor>();

        public QHtmlHelper Html { get; private set; }
        public dynamic _model;
        public dynamic _viewBag = new DynamicDirectory();

        public dynamic ViewBag
        {
            get { return _viewBag; }
            protected set { _viewBag=value; }
        }

        protected override void InitializePage()
        {
            base.InitializePage();
            Html = new QHtmlHelper();
        }




        public override void ExecutePageHierarchy()
        {
            base.ExecutePageHierarchy();
        }

        public dynamic Model
        {
            get { return _model ; }
            set { _model = value; }
        }


        private HttpContextBase _context;
        public override HttpContextBase Context
        {
            get { return _context; }
            set { _context = value; }
        }

        protected override void ConfigurePage(WebPageBase parentPage)
        {
            this.Context = parentPage.Context;
            MVCRzorPageBase pp = parentPage as MVCRzorPageBase;
            if (pp != null)
            {
                this._viewBag = pp.ViewBag;
                if (pp.Model is IMVCModel)
                {
                    IMVCModel model = pp.Model;
                    model.Init(pp);
                }
            }
            base.ConfigurePage(parentPage);
        }
    }
}
