﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Web;

namespace wuxiu.QMVC
{
    public class QHtmlHelper
    {

        public QHtmlHelper() { }
        public HtmlString Raw(string html)
        {
            return new HtmlString(html);
        }

        public IHtmlString Raw(object value)
        {
            return new HtmlString(value == null ? null : value.ToString());
        }
        public string Encode(object value)
        {
            return Encode(Convert.ToString(value, CultureInfo.InvariantCulture));
        }

        public string Encode(string value)
        {
            if (String.IsNullOrEmpty(value))
            {
                return String.Empty;
            }
            else
            {
                return HttpUtility.HtmlEncode(value);
            }
        }
    }
}
