﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using System.Web.WebPages;

namespace wuxiu.QMVC
{
    public class QMVCCore
    {
        public const string Controller_Lastfix="Controller";

        public static void page_BeginRequest(HttpContextBase context)
        {
            string url = Router.RouterManager.GetAppUrl(context);
            ControllerBase controller = Router.RouterManager.Router.LoadUrl(context,url);

            if (controller!=null)
            {
                MethodInfo minfo = controller.GetType().GetMethod(controller.ActionName, System.Reflection.BindingFlags.IgnoreCase | BindingFlags.Public | BindingFlags.Instance);
                if (minfo != null)
                {
                    object rval = minfo.Invoke(controller, new object[] { });
                    if (rval is ViewResult)
                    {
                        PrintResult(rval as ViewResult, controller);
                    }
                    else if (rval != null)
                    {
                        context.Response.Write(rval.ToString());
                    }
                    context.Response.End();
                }
                else
                {
                    controller.Response.StatusCode = 404;
                    controller.Response.End();
                }
            }
        }

        private static void PrintResult(ViewResult viewResult, ControllerBase controller)
        {
            controller.Response.ContentType = "text/html";
            PrintResultToStream(viewResult, controller, controller.Response.Output);
        }

        public static void PrintResultToStream(ViewResult viewResult, ControllerBase controller,TextWriter writer)
        {
            string cshtmlurl = viewResult.get_ViewPath();
            Type t = System.Web.Compilation.BuildManager.GetCompiledType(cshtmlurl);
            object instanse = Activator.CreateInstance(t);
            if (instanse == null)
            {
                controller.Response.Write("instanse is null"); return;
            }

            QMVC.MVCRzorPageBase webViewPage;
            try{

                webViewPage = (QMVC.MVCRzorPageBase)instanse;
            }catch{
                throw new Exception(
                 instanse.GetType().FullName + ":" + instanse.GetType().BaseType.FullName + ",page:"+cshtmlurl+" convert error.");
            }
            webViewPage.VirtualPath = cshtmlurl;
            HttpContextBase httpContextBase = controller.Context;
            webViewPage.Context = httpContextBase;
            webViewPage.Model = viewResult.Model;
            controller.InitRazor(webViewPage);
            if (viewResult.Model is IMVCModel)
            {
                ((IMVCModel)viewResult.Model).Init(webViewPage);
            }
            WebPageRenderingBase renderingBase = System.Web.WebPages.StartPage.GetStartPage(webViewPage, "_PageStart", new string[] { "cshtml" });
            
            webViewPage.ExecutePageHierarchy
                (
                new WebPageContext
                    (context: httpContextBase, page: renderingBase, model: viewResult.Model),
                    writer, renderingBase);
                /*
                new WebPageContext
                    (context: httpContextBase, page: null, model: viewResult.Model), 
                    writer, renderingBase);
                 * */
        }

    }
}
