﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;

namespace wuxiu.QMVC.Router
{
    public class DefaultRouter : IRouterProvider
    {
    
        string DefaultController;
        string DefaultAction;
        RouterControllerCollection controllers = new RouterControllerCollection();
        public DefaultRouter(Assembly asm, string defaultController, string defaultAction)
        {
            DefaultController = defaultController;
            DefaultAction = defaultAction;
            //
            controllers.LoadAssembly(asm);
        }

        public ControllerBase LoadUrl(HttpContextBase context, string apprawurl)
        {
            string controllerName = DefaultController;
            string action = DefaultAction;
            string pageurl;
            if (apprawurl.IndexOf('?') != -1)
            {
                pageurl = apprawurl.Substring(0, apprawurl.IndexOf('?'));
            }
            else pageurl = apprawurl;
            string[] urls= Utils.ClearStrArrayEmpty(pageurl.Split('/'));
            string[] urldata;
            if(urls.Length>0)
            {
                controllerName=urls[0];
            }else controllerName=DefaultController;
            if(urls.Length>1)
            {
                action=urls[1];
                if (!action.EndsWith(".action",StringComparison.OrdinalIgnoreCase))
                {
                    return null;
                } action = action.Substring(0,action.Length - ".action".Length);
            }else action=DefaultAction;

            if(urls.Length>2){
                urldata=new string[urls.Length-2];
                for(int i=2;i<urls.Length;i++)
                    urldata[i-2]=urls[i];
            }else urldata=new string[]{};

            Type ControllerType = controllers.GetController(controllerName);
            if (ControllerType != null)
            {
                ControllerBase controller = Activator.CreateInstance(ControllerType) as ControllerBase;
                controller.init(context, controllerName, action, urldata);
                return controller;
            }
            return null;
        }

    }
}
