﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace wuxiu.QMVC.Router
{
    public class RouterControllerCollection:Dictionary<string,Type>
    {
        public void LoadAssembly(Assembly asm)
        {
            foreach (Type t in asm.GetTypes())
            {
                if (t.IsPublic && t.IsSubclassOf(typeof(ControllerBase)) && !t.IsAbstract && t.Name.EndsWith(QMVCCore.Controller_Lastfix))
                {
                    try
                    {
                        this.Add(t.Name.ToLower(), t);
                    }
                    catch (Exception ex)
                    {
                        throw new Exception("在注册controller时，发现重名无法没册：" + t.FullName, ex);
                    }
                }
            }
        }

        public Type GetController(string controller)
        {
            string ControllerClassName = (controller+ QMVCCore.Controller_Lastfix).ToLower();
            if (this.ContainsKey(ControllerClassName))
            {
                return this[ControllerClassName];
            }
            return null;
        }


    }
}
