﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Web;

namespace wuxiu.QMVC.Router
{
    public static class RouterManager
    {
        internal static IRouterProvider Router;
        public static void SetRouter(IRouterProvider router)
        {
            Router = router;
        }

        public static string GetAppUrl(HttpContextBase context)
        {
            int apppathlen = context.Request.ApplicationPath.Length;
            return  context.Request.RawUrl.Substring(apppathlen);
        }

        public static void RegisterDefaultRouter(Type t)
        {
            Assembly asm = t.Assembly;
            wuxiu.QMVC.Router.DefaultRouter router = new Router.DefaultRouter(asm, "Home", "Index");
            wuxiu.QMVC.Router.RouterManager.SetRouter(router);

        }
    }
}
