﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace wuxiu.QMVC
{
    public delegate string TemplateUrlHandler(string themeName,string controllerName,string viewName);
    public class ViewResult
    {
        public string ViewName;
        public string ThemeName;
        public object Model;
        string ControllerName;
        TemplateUrlHandler OnGetTemplate;
        public string get_ViewPath()
        {
            return OnGetTemplate(ThemeName, ControllerName, ViewName);
        }
        protected virtual string getTemplateUrl(string themeName, string controllerName, string viewName)
        {
            return "~/Views/" + themeName + "/" + controllerName + "/" + viewName + ".cshtml";
        }
        public ViewResult(string viewName, string themeName, string controllerName, TemplateUrlHandler OnGetTemplate)
        {
            this.ViewName = viewName;
            this.ThemeName = themeName;
            this.ControllerName = controllerName;
            this.OnGetTemplate = OnGetTemplate;
        }
    }
}
