/*******************************************************************************
* KindEditor - WYSIWYG HTML Editor for Internet
* Copyright (C) 2006-2011 kindsoft.net
*
* @author Roddy <luolonghao@gmail.com>
* @site http://www.kindsoft.net/
* @licence http://www.kindsoft.net/license.php
*******************************************************************************/
var emary = ["\u5fae\u7b11","\u6487\u5634","\u8272","\u53d1\u5446","\u5f97\u610f","\u6d41\u6cea","\u5bb3\u7f9e",
"\u95ed\u5634","\u7761","\u5927\u54ed","\u5c34\u5c2c","\u53d1\u6012","\u8c03\u76ae","\u5472\u7259","\u60ca\u8bb6",
"\u96be\u8fc7","\u9177","\u51b7\u6c57","\u6293\u72c2","\u5410","\u5077\u7b11","\u53ef\u7231","\u767d\u773c",
"\u50b2\u6162","\u9965\u997f","\u56f0","\u60ca\u6050","\u6d41\u6c57","\u61a8\u7b11","\u5927\u5175","\u594b\u6597",
"\u5492\u9a82","\u7591\u95ee","\u5618","\u6655","\u6298\u78e8","\u8870","\u9ab7\u9ac5","\u6572\u6253",
"\u518d\u89c1","\u64e6\u6c57","\u62a0\u9f3b","\u9f13\u638c","\u7cd7\u5927\u4e86","\u574f\u7b11",
"\u5de6\u54fc\u54fc","\u53f3\u54fc\u54fc","\u54c8\u6b20","\u9119\u89c6","\u59d4\u5c48","\u5feb\u54ed\u4e86",
"\u9634\u9669","\u4eb2\u4eb2","\u5413","\u53ef\u601c","\u83dc\u5200","\u897f\u74dc","\u5564\u9152","\u7bee\u7403",
"\u4e52\u4e53","\u5496\u5561","\u996d","\u732a\u5934","\u73ab\u7470","\u51cb\u8c22","\u793a\u7231","\u7231\u5fc3",
"\u5fc3\u788e","\u86cb\u7cd5","\u95ea\u7535","\u70b8\u5f39","\u5200","\u8db3\u7403","\u74e2\u866b","\u4fbf\u4fbf",
"\u6708\u4eae","\u592a\u9633","\u793c\u7269","\u62e5\u62b1","\u5f3a","\u5f31","\u63e1\u624b","\u80dc\u5229",
"\u62b1\u62f3","\u52fe\u5f15","\u62f3\u5934","\u5dee\u52b2","\u7231\u4f60","NO","OK","\u7231\u60c5",
"\u98de\u543b","\u8df3\u8df3","\u53d1\u6296","\u6004\u706b","\u8f6c\u5708","\u78d5\u5934","\u56de\u5934",
"\u8df3\u7ef3","\u6325\u624b","\u6fc0\u52a8","\u8857\u821e","\u732e\u543b","\u5de6\u592a\u6781","\u53f3\u592a\u6781"];

KindEditor.plugin('emoticons', function(K) {
	var self = this, name = 'emoticons',
		path = (self.emoticonsPath || self.pluginsPath + 'emoticons/images/'),
		allowPreview = self.allowPreviewEmoticons === undefined ? true : self.allowPreviewEmoticons,
		currentPageNum = 1;
	self.clickToolbar(name, function() {
		var rows = 8, cols = 16, total = 105, startNum = 0,
			cells = rows * cols, pages = Math.ceil(total / cells),
			colsHalf = Math.floor(cols / 2),
			wrapperDiv = K('<div class="ke-plugin-emoticons"></div>'),
			elements = [],
			menu = self.createMenu({
				name : name,
				beforeRemove : function() {
					removeEvent();
				}
			});
		menu.div.append(wrapperDiv);
		var previewDiv, previewImg;
		if (allowPreview) {
			previewDiv = K('<div class="ke-preview"></div>').css('right', 0);
			previewImg = K('<img class="ke-preview-img" src="' + path + startNum + '.gif" />');
			wrapperDiv.append(previewDiv);
			previewDiv.append(previewImg);
		}
		function bindCellEvent(cell, j, num) {
			if (previewDiv) {
				cell.mouseover(function() {
					if (j > colsHalf) {
						previewDiv.css('left', 0);
						previewDiv.css('right', '');
					} else {
						previewDiv.css('left', '');
						previewDiv.css('right', 0);
					}
					
					if(num>=135 && num<=143){
						return false;
					}
					if(num>603){
						return false;
					}
					if(num>=144){
						previewImg.attr('src', path + eimgs[num-144] + '.png');
					}else{
						if(num<105){
							previewImg.attr('src', path + num + '.gif');
						}
					}
					K(this).addClass('ke-on');
				});
			} else {
				cell.mouseover(function() {
					K(this).addClass('ke-on');
				});
			}
			cell.mouseout(function() {
				K(this).removeClass('ke-on');
			});
			cell.click(function(e) {
				if(num>=105 && num<=143){
					return false;
				}
				if(num>603){
					return false;
				}
				if(num<144){
					if(num<105){
						self.insertHtml('<img src="' + path + num + '.gif" border="0" alt="qlmm-' + emary[num] + '" />').hideMenu().focus();
					}else{
						self.insertHtml('<img src="" border="0" alt="" />').hideMenu().focus();
					}
					
				}else{
					
					self.insertHtml('<img src="' + path +eimgs[num-144] + '.png" border="0" alt="" />').hideMenu().focus();
				}
				
				e.stop();
			});
		}
		function createEmoticonsTable(pageNum, parentDiv) {
			var table = document.createElement('table');
			parentDiv.append(table);
			if (previewDiv) {
				K(table).mouseover(function() {
					previewDiv.show('block');
				});
				K(table).mouseout(function() {
					previewDiv.hide();
				});
				elements.push(K(table));
			}
			table.className = 'ke-table';
			table.cellPadding = 0;
			table.cellSpacing = 0;
			table.border = 0;
			var num = (pageNum - 1) * cells + startNum;
			for (var i = 0; i < rows; i++) {
				var row = table.insertRow(i);
				for (var j = 0; j < cols; j++) {
					var cell = K(row.insertCell(j));
					cell.addClass('ke-cell');
					bindCellEvent(cell, j, num);
					var span ="";
					
					if(num>=144){
						if(num>603){
							span =K('<span class="ke-img"></span>');
						}else{
							
							span = K('<span class="ke-img"></span>');
							if(num>=144 && num <=287){
								var residue  = (num-144) % 18; 
								var divi  = Math.floor((num-144)/18); 
								
								span.css('background-image', 'url(' + path + 'qqe1.jpg)')
								.css('background-position', '-'+(residue*28+4)+'px -'+(divi*28+4)+'px');
							}
							if(num>=288 && num <=431){
								var residue  = (num-288) % 18; 
								var divi  = Math.floor((num-288)/18); 
								
								span.css('background-image', 'url(' + path + 'qqe2.jpg)')
								.css('background-position', '-'+(residue*28+4)+'px -'+(divi*28+4)+'px');
							}
							if(num>=432 && num <=575){
								var residue  = (num-432) % 18; 
								var divi  = Math.floor((num-432)/18); 
								
								span.css('background-image', 'url(' + path + 'qqe3.jpg)')
								.css('background-position', '-'+(residue*28+4)+'px -'+(divi*28+4)+'px');
							}
							if(num>=576 && num <=603){
								var residue  = (num-576) % 18; 
								var divi  = Math.floor((num-576)/18); 
								
								span.css('background-image', 'url(' + path + 'qqe4.jpg)')
								.css('background-position', '-'+(residue*28+4)+'px -'+(divi*28+4)+'px');
							}
							
							
							/**
							span =K('<img class="ke-img keeimg"  src="/keditor/plugins/emoticons/images/'+eimgs[num-144]+'.png"/>');
							**/
						}
						
                    }else{
                    	if(num<105){
	                    	span = K('<span class="ke-img"></span>')
							.css('background-position', '-' + (24 * num) + 'px 0px')
							.css('background-image', 'url(' + path + 'static.gif)');
                    	}else{
                    		span = K('<span class="ke-img"></span>');
                    	}
                    }
                   
					cell.append(span);
					elements.push(cell);
					num++;
				}
			}
			return table;
		}
		var table = createEmoticonsTable(currentPageNum, wrapperDiv);
		function removeEvent() {
			K.each(elements, function() {
				this.unbind();
			});
		}
		var pageDiv;
		function bindPageEvent(el, pageNum) {
			el.click(function(e) {
				removeEvent();
				table.parentNode.removeChild(table);
				pageDiv.remove();
				table = createEmoticonsTable(pageNum, wrapperDiv);
				createPageTable(pageNum);
				currentPageNum = pageNum;
				e.stop();
			});
		}
		function createPageTable(currentPageNum) {
			pageDiv = K('<div class="ke-page"></div>');
			wrapperDiv.append(pageDiv);
			for (var pageNum = 1; pageNum <= pages; pageNum++) {
				if (currentPageNum !== pageNum) {
					var a = K('<a href="javascript:;">[' + pageNum + ']</a>');
					bindPageEvent(a, pageNum);
					pageDiv.append(a);
					elements.push(a);
				} else {
					pageDiv.append(K('@[' + pageNum + ']'));
				}
				pageDiv.append(K('@&nbsp;'));
			}
		}
		createPageTable(currentPageNum);
	});
});
