﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Configuration;
using System.Text.RegularExpressions;
//www.mycodes.net
namespace WFApp
{
    public partial class AutoUpdate : Form
    {
        string filePath = ConfigurationManager.AppSettings["FilePath"].ToString();
        string targetPath = ConfigurationManager.AppSettings["TargetPath"].ToString();
        string Timing = ConfigurationManager.AppSettings["Timing"].ToString();
        string backPath = ConfigurationManager.AppSettings["backUpPath"].ToString();
        int count = 0;
        string fullPath = "C:/backup.txt";

        public AutoUpdate()
        {
            InitializeComponent();
            this.txtFile.Text = filePath;
            this.txtTo.Text = targetPath;
            this.txtTime.Text = Timing;
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        { 
            //调用备份方法 
            backup();  

            if (filePath != "")
            {
                if (CopyDir(filePath, targetPath))
                {
                    MessageBox.Show("更新成功！！！");
                }
                else
                {
                    MessageBox.Show("更新失败！！！");
                }
            }
            else
            {
                MessageBox.Show("请正确设置源地址!");
            }
        }

        private bool CopyDir(string srcPath, string aimPath)
        {
            bool copyFile = false;
            try
            {
                // 检查目标目录是否以目录分割字符结束如果不是则添加 
                if (aimPath[aimPath.Length - 1] != System.IO.Path.DirectorySeparatorChar)
                {
                    aimPath += System.IO.Path.DirectorySeparatorChar;
                }
                // 判断目标目录是否存在如果不存在则新建 
                if (!System.IO.Directory.Exists(aimPath))
                {
                    System.IO.Directory.CreateDirectory(aimPath);
                }
                // 得到源目录的文件列表，该里面是包含文件以及目录路径的一个数组 
                // 如果你指向copy目标文件下面的文件而不包含目录请使用下面的方法 
                // string[] fileList = Directory.GetFiles（srcPath）； 
                string[] fileList = System.IO.Directory.GetFileSystemEntries(srcPath);
                string str = "";
                if (count == 0)
                {
                    str = DateTime.Now.ToString() + "------";
                }

                // 遍历所有的文件和目录 
                foreach (string file in fileList)
                {
                    // 先当作目录处理如果存在这个目录就递归Copy该目录下面的文件 
                    if (System.IO.Directory.Exists(file))
                    {
                        CopyDir(file, aimPath + System.IO.Path.GetFileName(file));
                        if (count == 0)
                        {
                            str += file + ",";
                        }
                    }
                    // 否则直接Copy文件 
                    else
                    {
                        System.IO.File.Copy(file, aimPath + System.IO.Path.GetFileName(file), true);
                        if (count == 0)
                        {
                            str += file + ",";
                        }
                    }
                }

                if (System.IO.File.Exists(fullPath))
                {
                    using (StreamWriter sw = new StreamWriter(fullPath, true, Encoding.Default))
                    {
                        sw.WriteLine(str);
                    }
                }
                else
                {
                    File.Create(fullPath).Close();

                    using (StreamWriter sw = new StreamWriter(fullPath, true, Encoding.Default))
                    {
                        sw.WriteLine(str);
                    }
                }
                copyFile = true;

            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
            }
            return copyFile;
        }

        //恢复
        private void btnRestoration_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog dialog = new FolderBrowserDialog();
            dialog.Description = "请选择文件路径";
            if (dialog.ShowDialog() == DialogResult.OK)
            {
                string foldPath = dialog.SelectedPath;
                //this.txtFile.Text = foldPath;
                if (CopyDir(foldPath, targetPath))
                {
                    MessageBox.Show("恢复成功！");
                }
                else
                {
                    MessageBox.Show("恢复失败！");
                }
            }
        }

        //定时
        private void btnTimeUpdate_Click(object sender, EventArgs e)
        {
            string dt = DateTime.Now.ToString("HH:mm");
            //string time = this.txtTime.Text.Trim();//@"/^(?:[01]\d|2[0-3]):[0-5]\d$/"
            string ver = "^((0[0-9]|1[0-9]|2[0-3]):(0[0-9]|1[0-9]|2[0-9]|3[0-9]|4[0-9]|5[0-9]))$";
            this.timer.Enabled = true;
            timer.Interval = 30000;
            if (Timing != "" && Regex.IsMatch(Timing, ver))
            {
                if (dt == Timing)
                {
                    timer.Tick += new EventHandler(timer_Tick);
                }
            }
            else
            {
                MessageBox.Show("请正确填写时间！");
                this.chbUpdate.Checked = false;
                this.txtTime.Text = "";
            } 
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            backup(); 
            CopyDir(filePath, targetPath);
            this.Close();
        }

        //查看日志
        private void btnLog_Click(object sender, EventArgs e)
        {
            string filePath = "C:/backup.txt";
            if (File.Exists(filePath))
            {
                System.Diagnostics.Process.Start(filePath);
            }
            else
            {
                File.Create(filePath).Close();
                System.Diagnostics.Process.Start(filePath);
            }
        }

        public void backup()
        {
            count = 1;
            if (Directory.Exists(backPath))
            {
                DirectoryInfo dirpath = Directory.CreateDirectory(backPath + DateTime.Now.ToString("yyyy-MM-dd"));
                string backFile = dirpath.FullName.ToString();
                CopyDir(targetPath, backFile);
            }
            else
            {
                Directory.CreateDirectory(backPath);
                DirectoryInfo dirpath = Directory.CreateDirectory(backPath + DateTime.Now.ToString("yyyy-MM-dd"));
                string backFile = dirpath.FullName.ToString();
                CopyDir(targetPath, backFile);
            } 
            count = 0;
        }
    }
}
