﻿/*
 * 
 * 标题：基础类
 * 作者：DODO
 * 版权：www.taowaw.com
 * 日期：
 *      2012-05-02 PM 18:00
 * 
 */ 
using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Text.RegularExpressions;
using System.Configuration;

namespace taowaw.Common
{
    public class Utils
    {
        #region Request相关函数

        /// <summary>
        /// 取Get值
        /// </summary>
        /// <param name="_val"></param>
        /// <returns></returns>
        public static string Request(string _val)
        {
            string _temp = "";
            _temp = System.Web.HttpContext.Current.Request[_val];
            if (_temp == null)
            {
                _temp = "";
            }
            return _temp;
        }

        /// <summary>
        /// 取Get值(int)
        /// </summary>
        /// <param name="_val"></param>
        /// <returns></returns>
        public static int RequestInt(string _val)
        {
            string _temp = "";
            int _intTemp = 0;
            _temp = System.Web.HttpContext.Current.Request[_val];
            try
            {
                int _i = int.Parse(_temp);
                _intTemp = _i;
            }
            catch
            {
                _intTemp = 0;
            }
            return _intTemp;
        }


        /// <summary>
        /// 输出内容
        /// </summary>
        /// <param name="_templateTxt"></param>
        /// <returns></returns>
        public static void Response(string _templateTxt)
        {
            System.Web.HttpContext.Current.Response.Write(_templateTxt);
        }

        /// <summary>
        /// 结束输出
        /// </summary>
        public static void End()
        {
            System.Web.HttpContext.Current.Response.End();
        }

        /// <summary>
        /// 跳转地址
        /// </summary>
        /// <param name="_url"></param>
        public static void Redirect(string _url)
        {
            //Response("<script>location.href='"+_url+"';</script>");
            System.Web.HttpContext.Current.Response.Redirect(_url);
        }


        /// <summary>
        /// 服务器路径
        /// </summary>
        /// <param name="val"></param>
        /// <returns></returns>
        public static string MapPath(string val)
        {
            return HttpContext.Current.Server.MapPath(val);
        }

        #endregion

        #region 其它方法

        /// <summary>
        /// 字段串是否为Null或为""(空)
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static bool StrIsNullOrEmpty(string str)
        {
            //#if NET1
            if (str == null || str.Trim() == "")
            {
                return true;
            }
            //#else
            //            if (string.IsNullOrEmpty(str))
            //            {
            //                return true;
            //            }
            //#endif

            return false;
        }

        /// <summary>
        /// 分割字符串
        /// </summary>
        public static string[] SplitString(string strContent, string strSplit)
        {
            if (!Utils.StrIsNullOrEmpty(strContent))
            {
                if (strContent.IndexOf(strSplit) < 0)
                {
                    string[] tmp = { strContent };
                    return tmp;
                }
                return Regex.Split(strContent, Regex.Escape(strSplit), RegexOptions.IgnoreCase);
            }
            else
            {
                return new string[0] { };
            }
        }

        /// <summary>
        /// 分割字符串
        /// </summary>
        /// <returns></returns>
        public static string[] SplitString(string strContent, string strSplit, int count)
        {
            string[] result = new string[count];

            string[] splited = SplitString(strContent, strSplit);

            for (int i = 0; i < count; i++)
            {
                if (i < splited.Length)
                    result[i] = splited[i];
                else
                    result[i] = string.Empty;
            }

            return result;
        }

        /// <summary>
        /// 字符串反过来输出
        /// </summary>
        /// <param name="val">字符串(以,分隔)</param>
        public static string RevString(string val)
        {
            string tmpval = string.Empty;
            string[] arrtmpVal = val.Split(',');
            for (int i = arrtmpVal.Length - 1; i >= 0; i--)
            {
                if (tmpval == string.Empty)
                    tmpval = arrtmpVal[i].ToString();
                else
                    tmpval += "," + arrtmpVal[i].ToString();
            }

            return tmpval;
        }

        /// <summary>
        /// 删除字符串包含,的后面的,
        /// 如：aa,bb,,,,返回:aa,bb
        /// </summary>
        /// <param name="val"></param>
        /// <returns></returns>
        public static string RemoveStringLastStr(string val)
        {
            string tempval = string.Empty;
            string[] arrVal = val.Split(',');
            for (int i = 0; i < arrVal.Length; i++)
            {
                if (!string.IsNullOrEmpty(arrVal[i]))
                    tempval += "," + arrVal[i];
            }
            if (tempval.LastIndexOf(",") > -1)
                tempval = tempval.Substring(0, tempval.Length - 1);
            return tempval;
        }

        /// <summary>
        /// 过滤字符串最后一个字符：指定的包含字符
        /// </summary>
        /// <param name="val">字符串(以,分隔)</param>
        /// <param name="fstr">指定字符</param>
        /// <returns></returns>
        public static string FilterLastStr(string val, string fstr)
        {
            string tmpval = string.Empty;
            try
            {
                if (val.Substring(val.Length - 1, 1) == fstr)
                    tmpval = val.Substring(0, val.Length - 1);
                else
                    tmpval = val;
            }
            catch
            {
                tmpval = val;
            }

            return tmpval;
        } 
        #endregion

        #region 配置文件操作

        /// <summary>
        /// 取connectionStrings值
        /// </summary>
        /// <param name="name">名称</param>
        /// <returns></returns>
        public static string getConnectionStrings(string name)
        {
            return ConfigurationManager.ConnectionStrings[name].ConnectionString;
        }

        /// <summary>
        /// 取appSettings值
        /// </summary>
        /// <param name="key">关键字</param>
        /// <returns></returns>
        public static string getAppSettings(string key)
        {
            return ConfigurationManager.AppSettings[key].ToString();
        }

        #endregion
    }
}
