﻿using System;
using System.Configuration;

namespace Xueit.Config
{
    /// <summary>
    /// 基本设置描述类, 加[Serializable]标记为可序列化
    /// </summary>
    [Serializable]
    public class BaseConfigInfo
    {
        #region 私有字段

        private string _dbConnectstring = ConfigurationManager.ConnectionStrings["ConnectionString"].ConnectionString;  //数据库连接串
        private string _dbType = ConfigurationManager.ConnectionStrings["ConnectionString"].ProviderName; //数据库类型
        private string _dbServerip = string.Empty; //数据库服务器IP
        private string _dbServerLoginName = string.Empty; //数据库服务器登录用户名
        private string _dbServerLoginPassword = string.Empty; //数据库服务器登录密码
        private string _dbname = string.Empty;  //数据库名称

        #endregion

        #region 属性

        /// <summary>
        /// 数据库连接串
        /// </summary>
        public string Dbconnectstring
        {
            get { return _dbConnectstring; }
            set { _dbConnectstring = value; }
        }

        /// <summary>
        /// 数据库类型
        /// </summary>
        public string Dbtype
        {
            get { return _dbType; }
            set { _dbType = value; }
        }

        /// <summary>
        /// 数据库服务器IP
        /// </summary>
        public string dbServerip
        {
            get { return _dbServerip; }
            set { _dbServerip = value; }
        }

        /// <summary>
        /// 数据库服务器访问用户名
        /// </summary>
        public string dbServerLoginName
        {
            get { return _dbServerLoginName; }
            set { _dbServerLoginName = value; }
        }

        /// <summary>
        /// 数据库服务器访问密码
        /// </summary>
        public string dbServerLoginPassword
        {
            get { return _dbServerLoginPassword; }
            set { _dbServerLoginPassword = value; }
        }

        /// <summary>
        /// 数据库名称
        /// </summary>
        public string dbname
        {
            get { return _dbname; }
            set { _dbname = value; }
        }

        #endregion
    }
}
