﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Person.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Person.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Person.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Person.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Person.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Person.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 地区
	string regionID = Request.QueryString["RegionID"];
	if (!String.IsNullOrEmpty(regionID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubRegion"]))
		{
			condition.Append(and + Alias.Person.IncludeSubRegion + "=" + regionID);
		}
		else
		{
			if (regionID == "0")
				condition.Append(and + Alias.Person.RegionID + " IS NULL");
			else
				condition.Append(and + Alias.Person.RegionID + "=" + regionID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 语言
	string languageID = Request.QueryString["LanguageID"];
	if (!String.IsNullOrEmpty(languageID))
	{
		if (languageID == "0")
			condition.Append(and + Alias.Person.LanguageID + " IS NULL");
		else
			condition.Append(and + Alias.Person.LanguageID + "=" + languageID);
	}
	#endregion

	#region 性别
	string sexID = Request.QueryString["SexID"];
	if (!String.IsNullOrEmpty(sexID))
	{
		if (sexID == "0")
			condition.Append(and + Alias.Person.SexID + " IS NULL");
		else
			condition.Append(and + Alias.Person.SexID + "=" + sexID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Person.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Person.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Person.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Person.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Person.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Person.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Person.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Person.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Person.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Person.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Person.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Person.Up + " DESC";
			break;
		case "12":
			sort = Alias.Person.Up + " ASC";
			break;
		case "13":
			sort = Alias.Person.Down + " DESC";
			break;
		case "14":
			sort = Alias.Person.Down + " ASC";
			break;
		default:
			sort = Alias.Person.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}

protected bool ListByPicture
{
	get
	{
		if (Request.QueryString["ListByPicture"] != null)
			return Convert.ToBoolean(Request.QueryString["ListByPicture"]);
		else if (Request.Cookies["ListByPicture"] != null)
			return Convert.ToBoolean(Request.Cookies["ListByPicture"].Value);
		else
			return false;
	}
}
</script>
<ilghar:List ID="List" Object="Person" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True" />
<%If ListByPicture%>
	<ilghar:List Object="Person" Source="List">
		<ilghar:Row MaxCol="4">
			<ul>
				<ilghar:Col MaxRecord="1">
					<ilghar:Record>
						<li>
							<a href="edit.aspx?ID=<%=InnerID%>"><img src="<%=Thumbnail%>" /></a>
							<div class="<%=PageLang%>Font"><a href="edit.aspx?ID=<%=InnerID%>"><%=Name%></a><input type="checkbox" name="Sel" value="<%=InnerID%>" /></div>
						</li>
					</ilghar:Record>
				</ilghar:Col>
			</ul>
		</ilghar:Row>
	</ilghar:List>
<%Else%>
	<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
		<thead>
			<tr>
				<th width="40">选择</th>
				<th>名称</th>
				<th width="120">更新日期</th>
				<th width="40">人气</th>
				<th width="40">顶</th>
				<th width="40">踩</th>
			</tr>
		</thead>
		<tbody>
			<ilghar:List Object="Person" Source="List">
				<ilghar:Record>
					<tr id="Row<%=InnerID%>">
						<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
						<td class="<%=PageLang%>Font"><a href="edit.aspx?ID=<%=InnerID%>"><%=Name%></a></td>
						<td><%=UpdateTime%></td>
						<td><%=HitCount%></td>
						<td><%=Up%></td>
						<td><%=Down%></td>
					</tr>
				</ilghar:Record>
			</ilghar:List>
		</tbody>
	</table>
<%EndIf%>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>