﻿function BuildHeader()
{
	if (_page == "download_list")
		return BuildAjaxPath(true) + "?IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&PlatformID=" + $("#PlatformID").val() + "&LicenseID=" + $("#LicenseID").val() + "&TypeID=" + $("#TypeID").val() + "&LanguageID=" + $("#LanguageID").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "download_url_list")
		return BuildAjaxPath(true) + "?DownloadID=" + _downloadInnerID + ($("[name=CategoryID]")[0].selectedIndex == 0 ? "" : "&CategoryID=" + $("[name=CategoryID]")[0].val());
	else if (_page == "tag_select")
		return BuildAjaxPath(true) + "?Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
}	

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();
		}
	});
}

function MakeButton()
{
	var buttons = "";

	if (_page == "download_list")
	{
	    if ($("#IsRecycled")[0].selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if ($("#IsRecycled")[0].selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateDownload('Recover')\" >" + _lang_recover + "</button>";
	    }
	}
		
	$("#ExtraButton").html(buttons);
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Tag")
		path = "../tag/select.aspx";
	else if (type == "Platform")
		path = "../platform/select.aspx";

	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function SelectTag(tag, checked)
{
	var tags = $("[name=Tag]");
	for (var i = 0; i < tags.length; i++)
	{
		if (tags[i].id == tag.ID)
		{
			tags[i].checked = checked;
			return;
		}
	}
	
	var tagContainer = $("#TagDiv");
	var br = "";
	if (tags.length > 0 && tags.length % 5 == 0) br = "<br />";
	tagContainer.html(tagContainer.html() + br + "<input type='checkbox' checked='checked' name='Tag' id='" + tag.ID + "' tagName='" + tag.Name + "' tagPageGenerate='" + tag.PageGenerate + "' tagPageTemplate='" + tag.PageTemplate + "'' tagPageID='" + tag.PageID + "'' tagPageExtension='" + tag.PageExtension + "' /><label for='" + tag.ID + "'>" + tag.Name + "</label>");	
}

function SelectPlatform(platform, checked)
{
	var platforms = $("[name=Platform]");
	for (var i = 0; i < platforms.length; i++)
	{
		if (platforms[i].id == platform.ID)
		{
			platforms[i].checked = checked;
			return;
		}
	}
	
	var platformContainer = $("#PlatformDiv");
	var br = "";
	if (platforms.length > 0 && platforms.length % 5 == 0) br = "<br />";
	platformContainer.html(platformContainer.html() + br + "<input type='checkbox' checked='checked' name='Platform' id='" + platform.ID + "' value='" + platform.Name + "' PageGenerate='" + platform.PageGenerate + "' PageTemplate='" + platform.PageTemplate + "'' PageID='" + platform.PageID + "'' PageExtension='" + platform.PageExtension + "' /><label for='" + platform.ID + "'>" + platform.Name + "</label>");
}

function PrepareTag()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var tags = $("[name=Tag]");
	
	if (typeof(_tagIndex) != "undefined")
	{
	    _tagIndex = 0;
	}
	else
	{
	    _tagAddIndex = 0;
	    _tagDeleteIndex = 0;
	    _tagAddList.length = 0;
	    _tagDeleteList.length = 0;
    	    	
	    tags.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
					    break;
			    }
			    if (j >= _tags.length)
				    _tagAddList[_tagAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
				    {
					    _tagDeleteList[_tagDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_tags.length = 0;
	tags.each(function()
	{
		if (!this.checked)
		    return false;

		_tags[_tags.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PreparePlatform()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var platforms = $("[name=Platform]");
	
	if (typeof(_platformIndex) != "undefined")
	{
	    _platformIndex = 0;
	}
	else
	{
	    _platformAddIndex = 0;
	    _platformDeleteIndex = 0;
	    _platformAddList.length = 0;
	    _platformDeleteList.length = 0;
    	    	
	    platforms.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _platforms.length; j++)
			    {
				    if (this.id == _platforms[j] || this.id == _platforms[j].ID)
					    break;
			    }
			    if (j >= _platforms.length)
				    _platformAddList[_platformAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _platforms.length; j++)
			    {
				    if (this.id == _platforms[j] || this.id == _platforms[j].ID)
				    {
					    _platformDeleteList[_platformDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_platforms.length = 0;
	platforms.each(function()
	{
		if (!this.checked)
		    return false;

		_platforms[_platforms.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

//-------------------------------------------------
//Start : 下载管理
function AddDownload()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.Size.value.match(/^[\d\.]+$/))
	{
		Alert(_lang_size_incorrect, function(){this.Size.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	_urlIndex = 0;
	_urlTable = $("#UrlTable tbody")[0];

	var tag = PrepareTag();
	var platform = PreparePlatform();

	var category = $("[name=CategoryID] option:selected");
	var license = $("[name=LicenseID] option:selected");
	var type = $("[name=TypeID] option:selected");
	var language = $("[name=LanguageID] option:selected");

	SetCookie("CategoryID", category.val(), 10*360*24*60);	
	SetCookie("LicenseID", license.val(), 10*360*24*60);	
	SetCookie("TypeID", type.val(), 10*360*24*60);	
	SetCookie("LanguageID", language.val(), 10*360*24*60);	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);
		
	_createTime = new Date();

	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&Version=" + encodeURIComponent(this.Version.value);
	data += "&Size=" + encodeURIComponent(this.Size.value);
	data += "&LicenseID=" + this.LicenseID.value;
	data += "&LicenseName=" + license.attr("Name");
	data += "&LicensePageGenerate=" + license.attr("PageGenerate");
	data += "&LicensePageTemplate=" + license.attr("PageTemplate");
	data += "&LicensePageID=" + license.attr("PageID");
	data += "&LicensePageExtension=" + license.attr("PageExtension");
	data += "&TypeID=" + this.TypeID.value;
	data += "&TypeName=" + type.attr("Name");
	data += "&TypePageGenerate=" + type.attr("PageGenerate");
	data += "&TypePageTemplate=" + type.attr("PageTemplate");
	data += "&TypePageID=" + type.attr("PageID");
	data += "&TypePageExtension=" + type.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + type.attr("Name");
	data += "&LanguagePageGenerate=" + type.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + type.attr("PageTemplate");
	data += "&LanguagePageID=" + type.attr("PageID");
	data += "&LanguagePageExtension=" + type.attr("PageExtension");
	data += "&Developer=" + encodeURIComponent(this.Developer.value);
	data += "&Website=" + encodeURIComponent(this.Website.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Demo=" + encodeURIComponent(this.Demo.value);
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&PlatformNames=" + encodeURIComponent(platform.Names);
	data += "&PlatformPageGenerates=" + encodeURIComponent(platform.PageGenerates);
	data += "&PlatformPageTemplates=" + encodeURIComponent(platform.PageTemplates);
	data += "&PlatformPageIDs=" + encodeURIComponent(platform.PageIDs);
	data += "&PlatformPageExtensions=" + encodeURIComponent(platform.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddDownload_GetInnerID();
		}
	});
	
	return false;	
}

function AddDownload_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddDownload_SetPageID();
		}
	});
}

function AddDownload_SetPageID()
{
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_id),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddDownload_AddTag();
		}
	});
}

function AddDownload_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		AddDownload_AddPlatform();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddDownload_AddTag();
		}
	});
}

function AddDownload_AddPlatform()
{
	if (_platformIndex >= _platforms.length)
	{
		AddDownload_AddUrl();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&PlatformID=" + _platforms[_platformIndex];
	
	_platformIndex++;

    SetStatusMessage(_lang_adding_platform);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Platform&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddDownload_AddPlatform();
		}
	});
}

function AddDownload_AddUrl()
{
	if (_urlIndex >= _urlTable.rows.length)
	{
		Download_UploadPicture();
		return;
	}
	
	var urlCategoryID = _urlTable.rows[_urlIndex].cells[0].childNodes[0].value;
	var name = _urlTable.rows[_urlIndex].cells[1].childNodes[0].value;
	var url = _urlTable.rows[_urlIndex].cells[2].childNodes[0].value;
	
	_urlIndex++;
	if (name == "" || url == "")
	{
		AddDownload_AddUrl();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&CategoryID=" + urlCategoryID;
	data += "&Name=" + encodeURIComponent(name);
	data += "&Url=" + encodeURIComponent(url);
	
    SetStatusMessage(_lang_adding_url);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Url&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddDownload_AddUrl();
		}
	});
}

function EditDownload()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.Size.value.match(/^[\d\.]+$/))
	{
		Alert(_lang_size_incorrect, function(){this.Size.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	var tag = PrepareTag();
	var platform = PreparePlatform();
	
	var category = $("[name=CategoryID] option:selected");
	var license = $("[name=LicenseID] option:selected");
	var type = $("[name=TypeID] option:selected");
	var language = $("[name=LanguageID] option:selected");

	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&Version=" + encodeURIComponent(this.Version.value);
	data += "&Size=" + encodeURIComponent(this.Size.value);
	data += "&LicenseID=" + this.LicenseID.value;
	data += "&LicenseName=" + license.attr("Name");
	data += "&LicensePageGenerate=" + license.attr("PageGenerate");
	data += "&LicensePageTemplate=" + license.attr("PageTemplate");
	data += "&LicensePageID=" + license.attr("PageID");
	data += "&LicensePageExtension=" + license.attr("PageExtension");
	data += "&TypeID=" + this.TypeID.value;
	data += "&TypeName=" + type.attr("Name");
	data += "&TypePageGenerate=" + type.attr("PageGenerate");
	data += "&TypePageTemplate=" + type.attr("PageTemplate");
	data += "&TypePageID=" + type.attr("PageID");
	data += "&TypePageExtension=" + type.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&Developer=" + encodeURIComponent(this.Developer.value);
	data += "&Website=" + encodeURIComponent(this.Website.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Demo=" + encodeURIComponent(this.Demo.value);
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&PlatformNames=" + encodeURIComponent(platform.Names);
	data += "&PlatformPageGenerates=" + encodeURIComponent(platform.PageGenerates);
	data += "&PlatformPageTemplates=" + encodeURIComponent(platform.PageTemplates);
	data += "&PlatformPageIDs=" + encodeURIComponent(platform.PageIDs);
	data += "&PlatformPageExtensions=" + encodeURIComponent(platform.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_DeleteTag();
		}
	});

	return false;
}

function EditDownload_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditDownload_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Tag&Operation=Delete&DownloadID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_DeleteTag();
		}
	});
}

function EditDownload_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        EditDownload_DeletePlatform();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_AddTag();
		}
	});
}

function EditDownload_DeletePlatform()
{
	if (_platformDeleteIndex >= _platformDeleteList.length)
	{
		EditDownload_AddPlatform();
		return;
	}

	SetStatusMessage(_lang_modifying_platform);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Platform&Operation=Delete&DownloadID=" + _guid + "&PlatformID=" + _platformDeleteList[_platformDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_DeletePlatform();
		}
	});
}

function EditDownload_AddPlatform()
{
	if (_platformAddIndex >= _platformAddList.length)
	{
        Download_UploadPicture();
		return;
	}
	
	var data = "DownloadID=" + _guid;
	data += "&PlatformID=" + _platformAddList[_platformAddIndex];
	
	_platformAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Platform&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditDownload_AddPlatform();
		}
	});
}

function Download_UploadPicture()
{
    if (!_uploadPicture)
    {
        Download_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Object=Download&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Download_UploadThumbnail();
    	}
    });
}

function Download_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Object=Download&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function UpdateDownload(action, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateDownload(action, id);}, this);
		else
			UpdateDownload(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Download&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function AddClientUrl()
{
    var form = $("form")[0];
	SetCookie("UrlName", form.UrlName.value, 10*360*24*60);
	SetCookie("Extention", form.Extention.value, 10*360*24*60);
	
	var urlCategory = form.UrlCategoryID.outerHTML.replace("name=UrlCategoryID", "");
	var extention = form.Extention.value == "" ? "" : "." + form.Extention.value;

	var names = new Array();
	var urls = new Array();
	if (form.Type.value == "")
	{
		if (form.UrlName.value == "")
			names[names.length] = "01";
		else
			names[names.length] = form.UrlName.value;
		
		urls[urls.length] = form.UrlTemplate.value;
	}
	else if (form.Type.value == "0")
	{
		if (form.To.value.match(/^\d+$/) == null || form.From.value.match(/^\d+$/) == null || form.Wildcard.value.match(/^\d+$/) == null)
		{
			Alert(_lang_must_be_number);
			return;
		}
	
		var from, to, wildcard;
		if(parseInt(form.From.value) <= parseInt(form.To.value))
		{
			from = parseInt(form.From.value);
			to = parseInt(form.To.value);
		}
		else
		{
			from = parseInt(form.To.value);
			to = parseInt(form.From.value);
		}
			
		var wildcard = parseInt(form.Wildcard.value);	
		for (var i = from; i <= to; i++)
		{
			var r = "";
			var count = Math.max(wildcard, (i + "").length) - (i + "").length;
			for (var j = 0; j < count; j++)
				r += "0";
			r += i;

			if (form.UrlName.value.indexOf("(*)") == -1)
				names[names.length] = form.UrlName.value + r;
			else
				names[names.length] = form.UrlName.value.replace("(*)", r);
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					urls[urls.length] = form.UrlTemplate.value + r + extention;
				else
					urls[urls.length] = form.UrlTemplate.value.replace("(*)", r) + extention;
			}			
		}
	}
	else if (form.Type.value == "1")
	{
		if (!(form.From.value >= "a" && form.From.value <= "z") && !(form.From.value >= "A" && form.From.value <= "Z"))
		{
		    Alert(_lang_from_a_to_z, function(){this.From.select();}, this);
			return;
		}
		
		if (!(form.To.value >= "a" && form.To.value <= "z") && !(form.To.value >= "A" && form.To.value <= "Z"))
		{
		    Alert(_lang_to_a_to_z, function(){this.To.select();}, this);
			return;
		}
		
		var from, to;
		if(form.From.value <= form.To.value)
		{
			from = form.From.value.charCodeAt(0);
			to = form.To.value.charCodeAt(0);
		}
		else
		{
			from = form.To.value.charCodeAt(0);
			to = form.From.value.charCodeAt(0);
		}
		
		for (var i = from; i <= to; i++)
		{
			if (form.UrlName.value.indexOf("(*)") == -1)
				names[names.length] = form.UrlName.value + String.fromCharCode(i);
			else
				names[names.length] = form.UrlName.value.replace("(*)", String.fromCharCode(i));
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					urls[urls.length] = form.UrlTemplate.value + String.fromCharCode(i) + extention;
				else
					urls[urls.length] = form.UrlTemplate.value.replace("(*)", String.fromCharCode(i)) + extention;	
			}			
		}
	}
	
	var table = $("#UrlTable tbody")[0];
	for (var i = 0; i < names.length; i++)
	{
		var row = table.insertRow(-1);
		var cell = null;
		
		cell = row.insertCell(-1);
		cell.innerHTML = urlCategory;
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='text' value='" + names[i] + "' size='20' maxlength='50' />";
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='text' value='" + urls[i] + "' size='40' maxlength='255' />";
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='button' value='" + _lang_delete + "' onclick='DeleteClientUrl(this)' />";
	}
}

function DeleteClientUrl(input)
{
	var table = $("#UrlTable")[0];
	table.deleteRow(input.parentNode.parentNode.rowIndex);
}

function Type_OnChange()
{
    var form = this.form;
	if (this.value == "")
	{
		$("#Batch").hide();
	}
	else
	{
		if (this.value == "0")
		{
			form.From.maxLength = 3;
			form.From.value = "1";
			form.To.maxLength = 3;
			form.To.value = "2";
	
			$("#WildcardSpan").show();
		}
		else if (form.Type.value == "1")
		{
			form.From.maxLength = 1;
			form.From.value = "A";
			form.To.maxLength = 1;
			form.To.value = "B";
	
			$("#WildcardSpan").hide();
		}

		$("#Batch").show();
	}
}
//End : 下载管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 地址管理
function PrepareUrl()
{
    var form = $("form")[0];

	SetCookie("UrlName", form.UrlName.value, 10*360*24*60);
	SetCookie("Extention", form.Extention.value, 10*360*24*60);
	
	_categoryID = form.CategoryID.value;
	_extention = form.Extention.value == "" ? "" : "." + form.Extention.value;
	_counter = 0;
	
	_names = new Array();
	_urls = new Array();
	if (form.Type.value == "")
	{
		if (form.UrlName.value == "")
			_names[_names.length] = "01";
		else
			_names[_names.length] = form.UrlName.value;
		
		_urls[_urls.length] = form.UrlTemplate.value;
	}
	else if (form.Type.value == "0")
	{
		if (!form.To.value.match(/^\d+$/) || !form.From.value.match(/^\d+$/) || !form.Wildcard.value.match(/^\d+$/))
		{
			Alert(_lang_must_be_number);
			return;
		}
	
		var from, to, wildcard;
		if(parseInt(form.From.value) <= parseInt(form.To.value))
		{
			from = parseInt(form.From.value);
			to = parseInt(form.To.value);
		}
		else
		{
			from = parseInt(form.To.value);
			to = parseInt(form.From.value);
		}
			
		var wildcard = parseInt(form.Wildcard.value);	
		for (var i = from; i <= to; i++)
		{
			var r = "";
			var count = Math.max(wildcard, (i + "").length) - (i + "").length;
			for (var j = 0; j < count; j++)
				r += "0";
			r += i;

			if (form.UrlName.value.indexOf("(*)") == -1)
				_names[_names.length] = form.UrlName.value + r;
			else
				_names[_names.length] = form.UrlName.value.replace("(*)", r);
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					_urls[_urls.length] = form.UrlTemplate.value + r + _extention;
				else
					_urls[_urls.length] = form.UrlTemplate.value.replace("(*)", r) + _extention;
			}
		}
	}
	else if (form.Type.value == "1")
	{
		if (!(form.From.value >= "a" && form.From.value <= "z") && !(form.From.value >= "A" && form.From.value <= "Z"))
		{
		    Alert(_lang_from_a_to_z, function(){form.From.select();}, this);
			return;
		}
		
		if (!(form.To.value >= "a" && form.To.value <= "z") && !(form.To.value >= "A" && form.To.value <= "Z"))
		{
		    Alert(_lang_to_a_to_z, function(){form.To.select();}, this);
			return;
		}
		
		var from, to;
		if(form.From.value <= form.To.value)
		{
			from = form.From.value.charCodeAt(0);
			to = form.To.value.charCodeAt(0);
		}
		else
		{
			from = form.To.value.charCodeAt(0);
			to = form.From.value.charCodeAt(0);
		}
		
		for (var i = from; i <= to; i++)
		{
			if (form.UrlName.value.indexOf("(*)") == -1)
				_names[_names.length] = form.UrlName.value + String.fromCharCode(i);
			else
				_names[_names.length] = form.UrlName.value.replace("(*)", String.fromCharCode(i));
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					_urls[_urls.length] = form.UrlTemplate.value + String.fromCharCode(i) + _extention;
				else
					_urls[_urls.length] = form.UrlTemplate.value.replace("(*)", String.fromCharCode(i)) + _extention;	
			}
		}
	}
}

function AddUrl()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        returnfalse;
    }

    if (_counter >= _names.length)
    {
	    Alert(_lang_operation_success);
	    SetStatusMessage();
    	$(":submit")[0].disabled = false;

	    Search();
        return;
    }
    
	var data = "DownloadID=" + _downloadID;
	data += "&CategoryID=" + _categoryID;
	data += "&Name=" + encodeURIComponent(_names[_counter]);
	data += "&Url=" + encodeURIComponent(_urls[_counter]);
	
	_counter++;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Url&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    AddUrl();
		}
	});
}

function ModifyUrl(form, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);
	data += "&URL=" + encodeURIComponent(form.URL.value);

	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Url&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteUrl(id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Download.Url&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
}
//End : 地址管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "download_add")
	{
	    var form = $("form")[0];
	    form.UrlName.value = GetCookie("UrlName");
	    form.Extention.value = GetCookie("Extention");
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
	    CheckAndSelect(form.LicenseID, GetCookie("LicenseID"));
	    CheckAndSelect(form.TypeID, GetCookie("TypeID"));
	    CheckAndSelect(form.LanguageID, GetCookie("LanguageID"));
    	
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddDownload);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#PlatformSelect").click(function(){ShowSelectDialog("Platform")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("[name=UrlName],[name=Extention],[name=UrlTemplate]").keydown(function(e){if (e.keyCode == 13){AddClientUrl();e.preventDefault();}});
		$("#AddUrl").click(AddClientUrl);
		$("[name=Type]").change(Type_OnChange);
	}
	else if (_page == "download_edit")
	{
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }
        
        for (var i = 0; i < _platforms.length; i++)
        {
	        SelectPlatform(_platforms[i], true);
        }

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

		$("form").eq(0).submit(EditDownload);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#PlatformSelect").click(function(){ShowSelectDialog("Platform")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "download_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#PlatformID,#LicenseID,#TypeID,#LanguageID,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "download_url_list")
	{
		$("#List form").each(function()
		{
			var id = this.action;

			$(this).submit(function(){return ModifyUrl(this, id)});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteUrl(id);}, this);
				return false;
			});
		});

		if (arguments.length == 0)
		    return;

	    $("[name=UrlName]").val(GetCookie("UrlName"));
	    $("[name=Extention]").val(GetCookie("Extention"));

		$("form").eq(0).submit(function(){PrepareUrl();AddUrl();return false;});
		$("[name=CategoryID]").change(Search);
		$("[name=Type]").change(Type_OnChange);
	}
	else if (_page == "download_url_edit")
	{
		$("form").eq(0).submit(EditUrl);
	}
	else if (_page == "tag_select")
	{
		$(":checkbox").click(function()
		{
            if ($.browser.msie)
				window.dialogArguments.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").keydown(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "platform_select")
	{
		$(":checkbox").click(function()
		{
            if ($.browser.msie)
				window.dialogArguments.SelectPlatform({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectPlatform({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").keydown(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
}
Init(true);