﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>产品列表</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Block TBODY TD{text-align:center}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.Order.Detail.IsCanceled + "=false");
	string and = " AND ";

	#region 性质
	string kind = Request.QueryString["Kind"];
	if (kind != null && kind != "*")
		condition.Append(and + Alias.Order.Detail.Kind + "='" + kind + "'");
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Number")
			condition.Append(and + Alias.Order.Detail.OrderNumber + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "Member")
			condition.Append(and + Alias.Order.Detail.Member + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Order.Detail.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Order.Detail.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Order.Detail.InnerID + " ASC";
			break;
		case "3":
			sort = Alias.Order.Detail.ExpiredTime + " DESC";
			break;
		case "4":
			sort = Alias.Order.Detail.ExpiredTime + " ASC";
			break;
		default:
			sort = Alias.Order.Detail.InnerID + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = 1;
var _action = null;
function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		var list = document.getElementById("List");
		list.innerHTML = HandleFake404(xmlHttp);

		if (_action == "SetFile")
			alert("设置成功！");
	}
	else
	{
		if (_action == "SetFile")
			alert("设置失败！请查看日志！");
		else
			alert("失败！请查看日志！");
	}
	
	window.status = "";
}

function BuildHeader()
{
	return BuildAjaxPath(true) + "?Lang=<%=ContentLang%>&Kind=" + document.getElementById("Kind").value + "&Sort=" + document.getElementById("Sort").value + "&Keyword=" + encodeURIComponent(document.getElementById("Keyword").value) + "&KeywordType=" + document.getElementById("KeywordType").value + "&Page=" + _page;
}

function OnSearch()
{
	if (arguments.length > 0)
		_page = arguments[0];
	
	_action = "Search";
	_ajax.Post(BuildHeader(), null, XmlHttpCallBack);
	return false;
}

function OnSet(id)
{
	var auto = document.getElementById("Auto" + id);
	var file = document.getElementById("File" + id);
	
	window.status = "正在设置...";
	_action = "SetFile";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=SetFile&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()), "Auto=" + auto.checked + "&File=" + encodeURIComponent(file.value), XmlHttpCallBack);
}

function Auto_OnClick(checkbox, id)
{
	if (checkbox.checked)
		document.getElementById("FileSpan" + id).style.display = "none";
	else
		document.getElementById("FileSpan" + id).style.display = "";
}

function SelectFile(type, path)
{
	document.getElementById("File" + type).value = path;
}

function ShowSelectFileDialog(type)
{
	var path = "<%=AdminPath%>System/file_manager/select.aspx?Lang=<%=ContentLang%>&Type=" + type + "&ListByPicture=";
	path += "false&Root=<%=Config[TempFileFolder]%>";
	
	path = HandleFake404(path);
	if (g_browser == "IE")
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function ShowActionDialog(id, action)
{
	var path;
	var width, height;
	if (action == "Update")
	{
		path = "update.aspx?Lang=<%=ContentLang%>&ID=" + id;
		width = 600;
		height = 400;
	}
		
	path = HandleFake404(path);
	if (g_browser == "IE")
		window.showModalDialog(path, window, "status=0;dialogWidth=" + width + "px;dialogHeight=" + height + "px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=" + width + ",height=" + height + ",menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" onclick="OpenCloseLeftFrame()" /></div>
	<div class="Title">产品列表</div>
	<div class="Right">
		<ilgharUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" onmouseover="this.src='<%=ImagePath%>dropdown_over.gif';ShowLanguageMenu(this);" onmouseout="this.src='<%=ImagePath%>dropdown.gif'" />
		语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="list.aspx?Lang=<%=ContentLang%>">订单列表</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="add.aspx?Lang=<%=ContentLang%>">添加订单</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">产品列表</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="Kind" onchange="OnSearch()">
			<option value="*">所有性质</option>
			<option value="AutoSite">智能建站</option>
			<option value="Host">虚拟主机</option>
			<option value="WebSite">网站</option>
			<option value="Set">套餐</option>
			<option value="">其他</option>
		</select>
		<select id="Sort" onchange="OnSearch()">
			<option value="1">序号↓</option>
			<option value="2">序号↑</option>
			<option value="3">过期↓</option>
			<option value="4">过期↑</option>
		</select>
		<input id="Keyword" class="Text <%=ContentLang%>Font" onkeydown="if(event.keyCode == 13) OnSearch(1);" />
		<select id="KeywordType">
			<option value="Number">订单号</option>
			<option value="Member">会员名</option>
			<option value="Name">产品名</option>
		</select>
		<input type="button" value="搜索" class="Button" onclick="OnSearch(1)" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th>名称</th>
					<th>订单号</th>
					<th>会员</th>
					<th>创建时间</th>
					<th>状态</th>
					<th>操作</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Order.Detail" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ilghar:Record>
						<tr>
							<td class="<%=ContentLang%>Font">
								<a href="view.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a>
							</td>
							<td><a href="view.aspx?Lang=<%=ContentLang%>&amp;ID=<%=OrderInnerID%>"><%=OrderNumber%></a></td>
							<td class="<%=ContentLang%>Font"><%=Member%></td>
							<td><%=CreateTime%></td>
							<td>
								<%If Int32.Equals(DeliveredAmount, Amount)%>
									已发货
								<%ElseIf Convert.ToInt32(DeliveredAmount) > 0%>
									部分发货
								<%Else%>
									未发货
								<%EndIf%>
								<%If Convert.ToBoolean(OnTrial)%>
									，试用中
								<%EndIf%>
								<%If !Convert.IsDBNull(ExpiredTime)%>
									<%If DateTime.Now > Convert.ToDateTime(ExpiredTime)%>
										，已过期
										<%If String.Equals(Kind, "Host") && Guid.Equals(ServerID, Guid.Empty)%>
										，已删除
										<%EndIf%>
									<%Else%>
										，<%=Convert.ToDateTime(ExpiredTime).Subtract(DateTime.Now).Days + 1%>天后过期
									<%EndIf%>
								<%EndIf%>
							</td>
							<td>
								【<a href="feedback.aspx?ID=<%=InnerID%>">反馈</a>】

								<%If !Convert.IsDBNull(ExpiredTime) && Int32.Equals(DeliveredAmount, Amount) && (!String.Equals(Kind, "Host") || !Guid.Equals(ServerID, Guid.Empty))%>
									【<a href="javascript:ShowActionDialog(<%=InnerID%>, 'Update')">续费</a>】
								<%EndIf%>
								
								<%If String.Equals(Kind, "Host") && !Guid.Equals(ServerID, Guid.Empty)%>
									【<a href="host.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>">管理</a>】
									<ilghar:List Source="Manager.SplitToTable(ServerBindings)">
										<ilghar:Record>
											<a href="http://<%=[0]%>" target="_blank" style="display:block">http://<%=[0]%></a>
										</ilghar:Record>
									</ilghar:List>
								<%EndIf%>

								<%If String.Equals(Kind, "WebSite")%>
									<input type="checkbox" id="Auto<%=InnerID%>" onclick="Auto_OnClick(this, <%=InnerID%>)" /><label for="Auto<%=InnerID%>">自动</label>
									<span id="FileSpan<%=InnerID%>"><input type="text" id="File<%=InnerID%>" value="<%=File%>" size="10" /><input type="button" value="..." size="3" onclick="ShowSelectFileDialog(<%=InnerID%>)" /></span>
									<input type="button" value="设置" onclick="OnSet(<%=InnerID%>)" />
								<%EndIf%>
							</td>
						</tr>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript">
HandleFake404();
</script>
</body>
</html>