﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="OrderDetail" Object="Order.Detail" InnerID="Request.QueryString['ID']" />
<ilghar:Get ID="Order" Object="Order" Guid="OrderDetail[OrderID]" />
<ilghar:List ID="Unit" Object="Unit" />
<ilghar:Get ID="Balance" Mark="Member" Object="Deposit" Operation="GetBalance((Guid)Order[MemberID])" />
<ilghar:Get ID="Member" Mark="Member" Object="Member" Guid="Order[MemberID]" />
<ilghar:List ID="Discounts" Object="Discount" />
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-cache" />
<meta http-equiv="Expires" content="Mon,1 Fab 1979 23:36:05 GMT" />
<title>续费</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../../Host/S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=Manager.GetModulePath(null)%><%=Instance[IlgharCMS.SystemModule.Alias.Module.Namespace]%>/alias.js"></script>
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<style type="text/css">
TD TABLE{background:#FFF}
TD TABLE TH{width:100px}
#ChildTable THEAD TH,#ChildTable TBODY TD{width:auto;text-align:center}
</style>
<script language="c#" runat="server">
protected string GetUnitName(object unitID)
{
	if (Guid.Equals(unitID, Guid.Empty))
		return String.Empty;

	DataRow[] rows = Unit.Select(Alias.Unit.ID + "='" + unitID + "'");
	if (rows.Length == 0)
		return String.Empty;
	else
		return rows[0][Alias.Unit.Name].ToString();
}

protected int Discount
{
	get
	{
		int result = 100;
		string roleInnerIDs = Member[IlgharCMS.MemberModule.Alias.Member.RoleInnerIDs].ToString();
		foreach (DataRow discount in Discounts.Rows)
		{
			if (roleInnerIDs.Contains("|" + discount[Alias.Discount.RoleInnerID] + "|"))
			{
				if ((int)discount[Alias.Discount.Amount] < result)
					result = (int)discount[Alias.Discount.Amount];
			}
		}
		
		return result;
	}
}
</script>
<script type="text/javascript">
var _action = null;
var _price = <%=OrderDetail[Price]%>;
var _discount = <%=Discount%>;
var _taxRate = <%=Config[TaxRate]%>;
var _paymentNumber;
var _childIndex = 0;
var _children = new Array();

function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		if (_action == "Edit")
		{
			if (_childIndex < _children.length)
			{
				_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Modify&ID=" + _children[_childIndex].id, "DeliveredAmount=0&Amount=" + _children[_childIndex++].Amount, XmlHttpCallBack);
			}
			else
			{
				window.status = "正在续费...";
				_action = "Update";
				_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Update&ID=<%=Request.QueryString["ID"]%>", "PaymentNumber=" + _paymentNumber, XmlHttpCallBack);
			}
		}
		else if (_action == "Update")
		{
			_action = "MakePayment";
			window.status = "正在生成收款单...";
			_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Payment&Operation=Add", "OrderID=<%=Order[ID]%>&OrderDetailID=<%=OrderDetail[ID]%>&Number=" + _paymentNumber + "&Amount=" + document.getElementById("SumTD").innerHTML + "&Time=" + FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss") + "&Memo=" + encodeURIComponent("续费"), XmlHttpCallBack);
		}
		else if (_action == "MakePayment")
		{
			alert("续费成功！");
			document.getElementById("Submit").disabled = false;
			window.status = "";
			
			if (g_browser == "IE")
				window.dialogArguments.OnSearch();
			else
				window.opener.OnSearch();
			window.close();			
		}
	}
	else
	{
		if (_action == "Edit")
			alert("编辑失败！请查看日志！");
		else if (_action == "Update")
			alert("续费失败！请查看日志！");
		else if (_action == "MakePayment")
			alert("生成收款单失败！请查看日志！");
		else
			alert("失败！请查看日志！");
		document.getElementById("Submit").disabled = false;
		window.status = "";
			
		if (g_browser == "IE")
			window.dialogArguments.OnSearch();
		else
			window.opener.OnSearch();
		window.close();			
	}
}

function OnSubmit(form)
{
	if (!form.Amount.value.match(/^[1-9]\d*$/))
	{
		alert("数量不正确！");
		form.Amount.select();
		return;
	}
	
	if (!form.PriceAdjustment.value.match(/^-?\d+(\.\d+)?$/))
	{
		alert("折扣或涨价不正确！");
		form.PriceAdjustment.select();
		return false;
	}
	
	if (parseFloat(document.getElementById("SumTD").innerHTML) > <%=Balance%>)
	{
		alert("预存款不足！");
		return false;
	}
	
	_childIndex = 0;
	_children.length = 0;
	var spans = document.getElementsByTagName("SPAN");
	for (var i = 0; i < spans.length; i++)
	{
		if (typeof(spans[i].unitAmount) == "undefined")
			continue;

		_children[_children.length] = new Object();
		_children[_children.length - 1].ID = spans[i].id;
		_children[_children.length - 1].Amount = spans[i].innerHTML;
	}
	
	_paymentNumber = FormatDate(new Date(), "YYYYMMDDhhmmssSSS");
	
	var data = "DeliveredAmount=0&Amount=" + form.Amount.value;
	data += "&Discount=" + _discount;
	data += "&NeedInvoice=" + document.getElementById("NeedInvoiceYes").checked;
	data += "&TaxRate=" + _taxRate;
	data += "&PriceAdjustment=" + form.PriceAdjustment.value;
	data += "&Sum=" + document.getElementById("SumTD").innerHTML;
	
	document.getElementById("Submit").disabled = true;
	window.status = "正在操作...";
	_action = "Edit";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Modify&ID=<%=Request.QueryString["ID"]%>", data, XmlHttpCallBack);
	return false;
}

function Compute()
{
	var form = document.forms[0];
	
	var priceAdjustment = 0;
	if (!form.PriceAdjustment.value.match(/^-?\d+(\.\d+)?$/))
	{
		alert("折扣或涨价格式不正确！");
		return;
	}
	priceAdjustment = parseFloat(form.PriceAdjustment.value);
	priceAdjustment = parseFloat(priceAdjustment.toFixed(3));
	
	 var price = _price * parseInt(form.Amount.value);
	
	var beforeTax = price - price * (100 - _discount) / 100;
	var afterTax = beforeTax;
	if (document.getElementById("NeedInvoiceYes").checked)
		afterTax = beforeTax + beforeTax * _taxRate / 100;
	var sum = (afterTax + priceAdjustment).toFixed(2);
		
	document.getElementById("SumTD").innerHTML = sum;
}

function Amount_OnKeyUp(input)
{
	if (input.value == "")
		return;

	if (!input.value.match(/^[1-9]\d*$/))
	{
		alert("数量不正确！");
		input.select();
		return;
	}
	
	var spans = document.getElementsByTagName("SPAN");
	for (var i = 0; i < spans.length; i++)
	{
		if (typeof(spans[i].unitAmount) == "undefined")
			continue;

		spans[i].innerHTML = parseInt(spans[i].unitAmount) * parseInt(input.value);
	}
	
	Compute();
}
</script>
</head>
<body>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">续费</li>
		<li class="Right"></li>
	</ul>
	<form method="post" onsubmit="return OnSubmit(this)">
		<table border="0" cellpadding="4" cellspacing="1">
			<tbody>
				<tr>
					<th width="120">产品：</th>
					<td class="<%=ContentLang%>Font"><%=OrderDetail[Name]%></td>
				</tr>
				<tr>
					<th>数量：</th>
					<td><input type="text" name="Amount" value="1" size="5" maxlength="10" class="Text" onkeyup="Amount_OnKeyUp(this)" /><%=GetUnitName(OrderDetail[UnitID])%></td>
				</tr>
				<tr>
					<th>发票：</th>
					<td>
						<table border="0" cellpadding="4" cellspacing="1">
							<tr>
								<th>是否需要：</th>
								<td>
									<input type="radio" name="NeedInvoice" id="NeedInvoiceYes" onclick="Compute()" /><label for="NeedInvoiceYes">是</label>
									<input type="radio" name="NeedInvoice" id="NeedInvoiceNo" checked="checked" onclick="Compute()" /><label for="NeedInvoiceNo">否</label>
								</td>
							</tr>
							<tr>
								<th>税率：</th>
								<td><%=Config[TaxRate]%>%</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<th>折扣或涨价：</th>
					<td><input type="text" name="PriceAdjustment" value="0" size="5" maxlength="10" class="Text" onchange="Compute()" /></td>
				</tr>
				<tr>
					<th>会员：</th>
					<td class="<%=ContentLang%>Font"><%=Order[Member]%></td>
				</tr>
				<tr>
					<th>预存款：</th>
					<td><%=Balance%></td>
				</tr>
				<tr>
					<th>续费总额：</th>
					<td id="SumTD">0</td>
				</tr>
				<%If String.Equals(OrderDetail[Kind], "Set")%>
					<ilghar:List Object="Order.Detail" Condition="ParentID=OrderDetail[ID] and IsPresent=false">
						<tr>
							<td colspan="2">
								<table border="0" cellpadding="4" cellspacing="1">
									<thead>
										<tr>
											<th style="width:120px">货号</th>
											<th>名称</th>
											<th style="width:60px">数量</th>
										</tr>
									</thead>
									<tbody>
										<ilghar:Record>
											<tr>
												<td><%=ProductNumber%></td>
												<td class="<%=ContentLang%>Font"><%=Name%></td>
												<td class="<%=ContentLang%>Font"><span id="<%=InnerID%>" unitAmount="<%=UnitAmount%>"><%=UnitAmount%></span> <%=GetUnitName(UnitID)%></td>
											</tr>
										</ilghar:Record>
									</tbody>
								</table>
							</td>
						</tr>
					</ilghar:List>
				<%EndIf%>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" id="Submit" value="续费" />
					</td>
				</tr>
			</tfoot>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script type="text/javascript">
Compute();
</script>
</body>
</html>