﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="OrderDetail" Object="Order.Detail" InnerID="Request.QueryString['ID']" Validate="True" />
<ilghar:Get ID="Order" Object="Order" Guid="OrderDetail[OrderID]" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>查看</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" onclick="OpenCloseLeftFrame()" /></div>
	<div class="Title"><a href="list.aspx?Lang=<%=ContentLang%>">产品列表</a> → <span class="<%=ContentLang%>Font"><%=OrderDetail[Name]%></span></div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">查看</li>
		<li class="Right Selected"></li>
		<%If String.Equals(OrderDetail[Kind], "Host") && !Guid.Equals(OrderDetail[ServerID], Guid.Empty)%>
			<li class="Left"></li>
			<li class="Middle"><a href="host.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">管理</a></li>
			<li class="Right"></li>
		<%EndIf%>
		<li class="Left"></li>
		<li class="Middle"><a href="feedback.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">反馈</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<table border="0" cellpadding="4" cellspacing="1">
		<tbody>
			<tr>
				<th>订单号：</th>
				<td><%=Order[Number]%></td>
			</tr>
			<tr>
				<th>会员：</th>
				<td class="<%=ContentLang%>Font"><%=Order[Member]%></td>
			</tr>
			<tr>
				<th>性质：</th>
				<td>
					<%If String.Equals(OrderDetail[Kind], "AutoSite")%>
						智能建站
					<%ElseIf String.Equals(OrderDetail[Kind], "Host")%>
						虚拟主机
					<%ElseIf String.Equals(OrderDetail[Kind], "WebSite")%>
						网站
					<%ElseIf String.Equals(OrderDetail[Kind], "Set")%>
						套餐
					<%Else%>
						其他
					<%EndIf%>
				</td>
			</tr>
			<tr>
				<th>状态：</th>
				<td>
					<%If Int32.Equals(OrderDetail[DeliveredAmount], OrderDetail[Amount])%>
						已发货
					<%ElseIf Convert.ToInt32(OrderDetail[DeliveredAmount]) > 0%>
						部分发货
					<%Else%>
						未发货
					<%EndIf%>
					<%If Convert.ToBoolean(OrderDetail[OnTrial])%>
						，试用中
					<%EndIf%>
					<%If !Convert.IsDBNull(OrderDetail[ExpiredTime])%>
						<%If DateTime.Now > Convert.ToDateTime(OrderDetail[ExpiredTime])%>
							，已过期
						<%Else%>
							，<%=Convert.ToDateTime(OrderDetail[ExpiredTime]).Subtract(DateTime.Now).Days + 1%>天后过期
						<%EndIf%>
					<%EndIf%>
				</td>
			</tr>
			<tr>
				<th>创建时间：</th>
				<td><%=OrderDetail[CreateTime]%></td>
			</tr>
			<tr>
				<th>更新时间：</th>
				<td><%=OrderDetail[UpdateTime]%></td>
			</tr>
			<tr>
				<th>过期时间：</th>
				<td><%=OrderDetail[ExpiredTime]%></td>
			</tr>
		</tbody>
	</table>
	<div class="Footer"></div>
</div>
<script type="text/javascript">
HandleFake404();
</script>
</body>
</html>