﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Order" Object="Order" InnerID="Request.QueryString['ID']" />
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-cache" />
<meta http-equiv="Expires" content="Mon,1 Fab 1979 23:36:05 GMT" />
<title>生成发货单</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
TD TABLE{background:#FFF}
TD TABLE TH{width:100px}
#DetailTable THEAD TH,#DetailTable TBODY TD{width:auto;text-align:center}
</style>
<script type="text/javascript">
var _action = null;
var _productIndex = 0;
var _product = new Array();
function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		if (_action == "Deliver")
		{
			window.status = "正在生成发货单...";
			_action = "MakeDelivery";
			_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Delivery&Operation=Add", "Number=" + _product[_productIndex].DeliveryNumber + "&OrderID=" + _product[_productIndex].OrderID + "&OrderDetailID=" + _product[_productIndex].OrderDetailID + "&Amount=" + _product[_productIndex].Amount + "&Time=" + _product[_productIndex].Time + "&Memo=" + _product[_productIndex].Memo, XmlHttpCallBack);
		}
		else if (_action == "MakeDelivery")
		{
			_productIndex++;
			if (_productIndex < _product.length)
			{
				_action = "Deliver";
				_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Deliver&ID=" + _product[_productIndex].InnerID, "Amount=" + _product[_productIndex].Amount + "&Time=" + _product[_productIndex].Time + "&File=" + _product[_productIndex].File, XmlHttpCallBack);
			}
			else
			{
				alert("发货成功！");
				document.getElementById("Submit").disabled = false;
				window.status = "";
				
				if (g_browser == "IE")
					window.dialogArguments.OnSearch();
				else
					window.opener.OnSearch();
				window.close();			
			}
		}
		else if (_action == "Try")
		{
			alert("已开通试用成功！");
			document.getElementById("Submit").disabled = false;
			window.status = "";
		}
	}
	else
	{
		if (_action == "Deliver")
			alert("发货失败！请查看日志！");
		else if (_action == "MakeDelivery")
			alert("生成发货单失败！请查看日志！");
		else if (_action == "Try")
			alert("开通试用失败！请查看日志！");
		else
			alert("失败！请查看日志！");
		document.getElementById("Submit").disabled = false;
		window.status = "";
	}
}

function OnSubmit(form)
{
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(form.Time.value))
	{
		alert("发货时间格式不正确！");
		form.Time.select();
		return false;
	}
	
	var number = FormatDate(new Date(), "YYYYMMDDhhmmssSSS");

	_productIndex = 0;
	_product.length = 0;
	var rows = document.getElementById("DetailTable").rows;
	for (var i = 1; i < rows.length; i++)
	{
		var amount = document.getElementById("Amount" + rows[i].id);
		if (amount == null)
			continue;
			
		if (!amount.value.match(/^\d+$/))
		{
			alert("发货量格式不正确！");
			amount.select();
			return false;
		}
		
		if (parseInt(amount.value) == 0)
			continue;
		
		if (parseInt(rows[i].cells[2].innerHTML) - parseInt(rows[i].cells[3].innerHTML) < parseInt(amount.value))
		{
			alert("发货量不能超过所需数量！");
			amount.select();
			return false;
		}
		
		_product[_product.length] = new Object();
		_product[_product.length - 1].InnerID = rows[i].id;
		_product[_product.length - 1].DeliveryNumber = (document.getElementById("Number" + rows[i].id).value == "" ? number + "-" + i : document.getElementById("Number" + rows[i].id).value);
		_product[_product.length - 1].OrderID = "<%=Order[ID]%>";
		_product[_product.length - 1].OrderDetailID = rows[i].guid;
		_product[_product.length - 1].Time = form.Time.value;
		_product[_product.length - 1].Amount = amount.value;
		_product[_product.length - 1].Memo = encodeURIComponent(document.getElementById("Memo" + rows[i].id).value);
		
		var file = document.getElementById("File" + rows[i].id);
		if (file != null)
			_product[_product.length - 1].File = encodeURIComponent(file.value);
		else
			_product[_product.length - 1].File = "";
	}
	
	if (_product.length == 0)
	{
		alert("没有任何可发货的产品！");
		return false;
	}
	
	document.getElementById("Submit").disabled = true;
	window.status = "正在发货...";
	_action = "Deliver";
	if (_productIndex < _product.length)
		_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Deliver&ID=" + _product[_productIndex].InnerID, "Amount=" + _product[_productIndex].Amount + "&Time=" + _product[_productIndex].Time + "&File=" + _product[_productIndex].File, XmlHttpCallBack);
	return false;
}

function SelectFile(type, path)
{
	document.getElementById("File" + type).value = path;
}

function ShowSelectFileDialog(type)
{
	var path = "<%=AdminPath%>System/file_manager/select.aspx?Lang=<%=ContentLang%>&Type=" + type + "&ListByPicture=";
	path += "false&Root=<%=Config[TempFileFolder]%>";
	
	path = HandleFake404(path);
	if (g_browser == "IE")
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function Try(input)
{
	var id = input.parentNode.parentNode.id;
	
	input.disabled = true;
	document.getElementById("Submit").disabled = true;
	window.status = "正在开通试用...";
	_action = "Try";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Try&ID=" + id, null, XmlHttpCallBack);
}
</script>
</head>
<body>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">生成发货单</li>
		<li class="Right"></li>
	</ul>
	<form method="post" onsubmit="return OnSubmit(this)">
		<table border="0" cellpadding="4" cellspacing="1">
			<tbody>
				<tr>
					<th>订单号：</th>
					<td><%=Order[Number]%></td>
				</tr>
				<tr>
					<th>发货时间：</th>
					<td><input type="text" name="Time" value="<%=DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")%>" maxlength="20" class="Text" /></td>
				</tr>
				<tr>
					<td colspan="2">
						<table id="DetailTable" border="0" cellpadding="4" cellspacing="1">
							<thead>
								<tr>
									<th style="width:100px">发货单</th>
									<th>名称</th>
									<th style="width:60px">需发货</th>
									<th style="width:60px">已发货</th>
									<th style="width:60px">发货量</th>
									<th>备注和其他</th>
								</tr>
							</thead>
							<tbody>
								<ilghar:List Object="Order.Detail" Condition="OrderID=Order[ID] and ParentID IS NULL">
									<ilghar:Record>
										<tr id="<%=InnerID%>" guid="<%=ID%>">
											<td><input type="text" id="Number<%=InnerID%>" size="10" maxlength="50" class="Text" /></td>
											<td style="text-align:left" class="<%=ContentLang%>Font">
												<%=Name%>
												<%If String.Equals(Kind, "AutoSite")%>
													<ilghar:List Object="Order.Detail" Condition="OrderID=Order[ID] and ParentID=ID">
														<ilghar:Record>
															<blockquote style="margin:0 0 0 20px">+ <%=Name%></blockquote>
														</ilghar:Record>
													</ilghar:List>
												<%EndIf%>
											</td>
											<td><%=Amount%></td>
											<td><%=DeliveredAmount%></td>
											<td>
												<%If Convert.ToInt32(Amount) > Convert.ToInt32(DeliveredAmount)%>
													<input type="text" id="Amount<%=InnerID%>" value="0" size="5" />
												<%Else%>
													0
												<%EndIf%>
											</td>
											<td>
												<%If String.Equals(Kind, "WebSite")%>
													<input type="text" id="File<%=InnerID%>" size="10" /><input type="button" value="..." size="3" onclick="ShowSelectFileDialog(<%=InnerID%>)" />
												<%EndIf%>
												<textarea id="Memo<%=InnerID%>" cols="15" rows="3" wrap="off" class="Text <%=ContentLang%>Font"></textarea>
												<%If !Convert.ToBoolean(OnTrial) && Int32.Equals(DeliveredAmount, 0) && Guid.Equals(ServerID, Guid.Empty)%>
													<ilghar:List Object="Product" Page="1" PageSize="1" Condition="ID=ProductID">
														<ilghar:Record>
															<%If Convert.ToBoolean(CanTry)%>
																<input type="button" value="试用" onclick="Try(this)" />
															<%EndIf%>
														</ilghar:Record>
													</ilghar:List>
												<%EndIf%>
											</td>
										</tr>
										<%If String.Equals(Kind, "Set")%>
											<ilghar:List Object="Order.Detail" Condition="OrderID=Order[ID] and ParentID=ID">
												<ilghar:Record>
													<tr id="<%=InnerID%>" guid="<%=ID%>">
														<td><input type="text" id="Number<%=InnerID%>" size="10" maxlength="50" class="Text" /></td>
														<td class="<%=ContentLang%>Font" style="padding-left:20px;text-align:left">+<%=Name%></td>
														<td><%=Amount%></td>
														<td><%=DeliveredAmount%></td>
														<td>
															<%If Convert.ToInt32(Amount) > Convert.ToInt32(DeliveredAmount)%>
																<input type="text" id="Amount<%=InnerID%>" value="0" size="5" />
															<%Else%>
																0
															<%EndIf%>
														</td>
														<td>
															<%If String.Equals(Kind, "WebSite")%>
																<input type="text" id="File<%=InnerID%>" size="10" /><input type="button" value="..." size="3" onclick="ShowSelectFileDialog(<%=InnerID%>)" />
															<%EndIf%>
															<textarea id="Memo<%=InnerID%>" cols="15" rows="3" wrap="off" class="Text <%=ContentLang%>Font"></textarea>
															<%If !Convert.ToBoolean(OnTrial)%>
																<ilghar:List Object="Product" Page="1" PageSize="1" Condition="ID=ProductID">
																	<ilghar:Record>
																		<%If Convert.ToBoolean(CanTry)%>
																			<input type="button" value="试用" onclick="Try(this)" />
																		<%EndIf%>
																	</ilghar:Record>
																</ilghar:List>
															<%EndIf%>
														</td>
													</tr>
												</ilghar:Record>
											</ilghar:List>
										<%EndIf%>
									</ilghar:Record>
								</ilghar:List>
							</tbody>
						</table>
					</td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" id="Submit" value="发货" />
					</td>
				</tr>
			</tfoot>
		</table>
	</form>
	<div class="Footer"></div>
</div>
</body>
</html>