﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Member" Object="Member" InnerID="Request.QueryString['MemberID']" />
<ilghar:Get ID="Balance" Object="Member.Point" Operation="GetBalance((Guid)Member[ID])" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>积分管理</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<script language="c#" runat="server">
private decimal _balance = -1;
protected decimal GetBalance(object amount)
{
	if (_balance == -1)
		_balance = Balance;
	decimal result = _balance;
	_balance -= Convert.ToDecimal(amount);
	return result;
}
</script>
<script type="text/javascript">
var _page = "member_point_list";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _memberID = "<%=Member[ID]%>";
var _userName = "<%=User["Name"]%>";
var _lang_working = "正在操作...";
var _lang_operation_success = "操作成功！";
var _lang_operation_fail = "操作失败！";
var _lang_amount_incorrect = "充值积分格式不正确！";
var _lang_time_incorrect = "交易时间格式不正确！";
var _lang_title_plus = "代充值";
var _lang_title_minus = "代扣费";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title"><a href="../list.aspx?Lang=<%=ContentLang%>">会员列表</a> → <span class="<%=ContentLang%>Font"><%=Member[Name]%></span></div>
	<div class="Right">
		<ilgharUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="../edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["MemberID"]%>">编辑</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../money/list.aspx?Lang=<%=ContentLang%>&amp;MemberID=<%=Request.QueryString["MemberID"]%>">资金管理</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">积分管理</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<form>
			充值点数（增/减）：<input name="Amount" maxlength="10" class="Text" />
			交易时间：<input type="text" name="Time" value="<%=DateTime.Now.ToString("yyyy-MM-dd")%>" class="Wdate" />
			备注：<input name="Memo" size="25" maxlength="255" class="Text <%=ContentLang%>Font" />
			<input type="submit" value="充值" />
		</form>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th>交易时间</th>
					<th>业务摘要</th>
					<th>转入金额</th>
					<th>转出金额</th>
					<th>当前余额</th>
					<th>备 注</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Member.Point" Page="PageNumber" PageSize="20" Condition="MemberID=Member[ID]" Sort="CreateTime DESC" Validate="True">
					<ilghar:Record>
						<tr>
							<td><%=CreateTime%></td>
							<td class="<%=ContentLang%>Font"><%=Title%></td>
							<%If Convert.ToDecimal(Amount) > 0%>
								<td><%=Amount%></td>
								<td>0</td>
							<%Else%>
								<td>0</td>
								<td><%=-1 * Convert.ToDecimal(Amount)%></td>
							<%EndIf%>
							<td><%=GetBalance(Amount)%></td>
							<td class="<%=ContentLang%>Font"><%=Memo%></td>
						</tr>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>		
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>date_picker/date_picker.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=JsPath%>member.js"></script>
</body>
</html>